package io.mockative

import io.mockative.matchers.Matcher
import io.mockative.matchers.SpecificArgumentsMatcher

class VerifyFunction2Builder<P1, P2>(private val receiver: Mockable, private val function: String) {
    fun with(p1: Matcher<P1> = anything(), p2: Matcher<P2> = anything()): Verification {
        val matcher = SpecificArgumentsMatcher(listOf(p1, p2))
        return Verification(receiver, Expectation.Function(function, matcher))
    }
}