package io.mockative

import io.mockative.matchers.Matcher
import io.mockative.matchers.SpecificArgumentsMatcher

class VerifyFunction1Builder<P1>(private val receiver: Mockable, private val function: String) {
    fun with(p1: Matcher<P1> = anything()): Verification {
        val matcher = SpecificArgumentsMatcher(listOf(p1))
        return Verification(receiver, Expectation.Function(function, matcher))
    }
}