package io.mockative

import io.mockative.matchers.ArgumentsMatcher
import io.mockative.matchers.Matcher
import io.mockative.matchers.SpecificArgumentsMatcher
import kotlin.reflect.KFunction

class GivenFunction3Builder<P1, P2, P3, R>(private val mock: Mockable, private val function: KFunction<R>) {
    fun whenInvokedWith(p1: Matcher<P1> = anything(), p2: Matcher<P2> = anything(), p3: Matcher<P3> = anything()): ResultBuilder {
        val arguments = SpecificArgumentsMatcher(listOf(p1, p2, p3))
        return ResultBuilder(arguments)
    }

    @Suppress("UNCHECKED_CAST")
    inner class ResultBuilder(private val arguments: ArgumentsMatcher) : AnyResultBuilder<R> {
        fun then(block: (P1, P2, P3) -> R) {
            val expectation = Expectation.Function(function.name, arguments)
            val stub = BlockingStub(expectation) { args ->
                block(args[0] as P1, args[1] as P2, args[2] as P3)
            }
            mock.addBlockingStub(stub)
        }

        override fun thenInvoke(block: () -> R) = then { _, _, _ -> block() }
    }
}