/*
 * Decompiled with CFR 0.152.
 */
package io.mockative;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.ksp.OriginatingKSFilesKt;
import io.mockative.MockativeConfiguration;
import io.mockative.MockativeSymbolProcessorProviderKt;
import io.mockative.ProcessableType;
import io.mockative.kotlinpoet.AnnotationAggregator;
import io.mockative.kotlinpoet.ClassName_MockativeKt;
import io.mockative.kotlinpoet.ProcessableType_KotlinPoetKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/mockative/MockativeSymbolProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "options", "", "", "<init>", "(Lcom/google/devtools/ksp/processing/CodeGenerator;Ljava/util/Map;)V", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "mockative-processor"})
@SourceDebugExtension(value={"SMAP\nMockativeSymbolProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockativeSymbolProcessor.kt\nio/mockative/MockativeSymbolProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1863#2,2:84\n1863#2,2:86\n*S KotlinDebug\n*F\n+ 1 MockativeSymbolProcessor.kt\nio/mockative/MockativeSymbolProcessor\n*L\n37#1:84,2\n56#1:86,2\n*E\n"})
public final class MockativeSymbolProcessor
implements SymbolProcessor {
    @NotNull
    private final CodeGenerator codeGenerator;
    @NotNull
    private final Map<String, String> options;

    public MockativeSymbolProcessor(@NotNull CodeGenerator codeGenerator, @NotNull Map<String, String> options) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.codeGenerator = codeGenerator;
        this.options = options;
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        try {
            FileSpec file;
            ProcessableType type;
            KSPLogger.info$default((KSPLogger)MockativeSymbolProcessorProviderKt.getLog(), (String)("options: " + this.options), null, (int)2, null);
            MockativeConfiguration configuration = MockativeConfiguration.Companion.fromOptions(this.options);
            KSPLogger.info$default((KSPLogger)MockativeSymbolProcessorProviderKt.getLog(), (String)("configuration: " + configuration), null, (int)2, null);
            if (configuration.getDisabled()) {
                KSPLogger.info$default((KSPLogger)MockativeSymbolProcessorProviderKt.getLog(), (String)"Code generation is disabled due to plugin being disabled", null, (int)2, null);
                return CollectionsKt.emptyList();
            }
            List<ProcessableType> processableTypes = ProcessableType.Companion.fromResolver(configuration, resolver);
            KSPLogger.info$default((KSPLogger)MockativeSymbolProcessorProviderKt.getLog(), (String)("Found '" + processableTypes.size() + "' processable types"), null, (int)2, null);
            Iterable $this$forEach$iv = processableTypes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                type = (ProcessableType)element$iv;
                boolean bl = false;
                ClassName sourceClassName = type.getSourceClassName();
                ClassName mockClassName = type.getMockClassName();
                String packageName = mockClassName.getPackageName();
                String fileName = ClassName_MockativeKt.getFullSimpleName(mockClassName);
                KSPLogger.info$default((KSPLogger)MockativeSymbolProcessorProviderKt.getLog(), (String)("Generating mock class '" + mockClassName + "' for '" + sourceClassName + "'"), null, (int)2, null);
                file = FileSpec.Companion.builder(packageName, fileName).addType(ProcessableType_KotlinPoetKt.buildMockTypeSpec(type)).build();
                KSPLogger.info$default((KSPLogger)MockativeSymbolProcessorProviderKt.getLog(), (String)("  Writing mock class '" + mockClassName + "' to '" + file.getRelativePath() + "'"), null, (int)2, null);
                OriginatingKSFilesKt.writeTo$default((FileSpec)file, (CodeGenerator)this.codeGenerator, (boolean)false, null, (int)4, null);
            }
            $this$forEach$iv = processableTypes;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                type = (ProcessableType)element$iv;
                boolean bl = false;
                ClassName mockClassName = type.getMockClassName();
                String reflectionName = type.getSourceClassName().reflectionName();
                String fileName = reflectionName + ".Mockative";
                KSPLogger.info$default((KSPLogger)MockativeSymbolProcessorProviderKt.getLog(), (String)("Generating function for '" + mockClassName + "'"), null, (int)2, null);
                AnnotationAggregator annotations = new AnnotationAggregator();
                file = ((FileSpec.Builder)FileSpec.Companion.builder("io.mockative", fileName).addFunctions((Iterable)ProcessableType_KotlinPoetKt.buildMockFunSpecs(type))).addAnnotations((Iterable)annotations.build()).build();
                KSPLogger.info$default((KSPLogger)MockativeSymbolProcessorProviderKt.getLog(), (String)("  Writing function for '" + mockClassName + "' to '" + file.getRelativePath() + "'"), null, (int)2, null);
                OriginatingKSFilesKt.writeTo$default((FileSpec)file, (CodeGenerator)this.codeGenerator, (boolean)false, null, (int)4, null);
            }
            return CollectionsKt.emptyList();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }
}

