package io.mockative

import io.mockative.matchers.SpecificArgumentsMatcher
import kotlin.reflect.KFunction
import kotlin.reflect.KMutableProperty
import kotlin.reflect.KProperty

class VerifyThatBuilder<T : Any>(private val receiver: T) {
    fun <R> invocation(block: T.() -> R): Verification {
        val mock = receiver.asMockable()
        val invocation = mock.record(block)
        val expectation = invocation.toExpectation()
        return Verification(mock, expectation)
    }

    suspend fun <R> coroutine(block: suspend T.() -> R): Verification {
        val mock = receiver.asMockable()
        val invocation = mock.record(block)
        val expectation = invocation.toExpectation()
        return Verification(mock, expectation)
    }

    fun <V> getter(property: KProperty<V>): Verification = Verification(receiver.asMockable(), Expectation.Getter(property.name))
    fun getter(name: String): Verification = Verification(receiver.asMockable(), Expectation.Getter(name))

    fun <V> setter(property: KMutableProperty<V>): VerifyThatSetterBuilder<V> = VerifyThatSetterBuilder(receiver.asMockable(), property.name)
    fun setter(name: String): VerifyThatSetterBuilder<Any?> = VerifyThatSetterBuilder(receiver.asMockable(), name)


    fun function(function: String): VerifyFunctionBuilder = VerifyFunctionBuilder(receiver.asMockable(), function)

    fun <R, F> function(function: F): Verification where F : () -> R, F : KFunction<R> = Verification(receiver.asMockable(), Expectation.Function(function.name, SpecificArgumentsMatcher(emptyList())))
    fun <R, F> function(function: F, type: KFunction0): Verification where F : () -> R, F : KFunction<R> = Verification(receiver.asMockable(), Expectation.Function(function.name, SpecificArgumentsMatcher(emptyList())))

    fun <P1, R, F> function(function: F): VerifyFunction1Builder<P1> where F : (P1) -> R, F : KFunction<R> = VerifyFunction1Builder(receiver.asMockable(), function.name)
    fun <P1, R, F> function(function: F, type: KFunction1<P1>): VerifyFunction1Builder<P1> where F : (P1) -> R, F : KFunction<R> = VerifyFunction1Builder(receiver.asMockable(), function.name)

    fun <P1, P2, R, F> function(function: F): VerifyFunction2Builder<P1, P2> where F : (P1, P2) -> R, F : KFunction<R> = VerifyFunction2Builder(receiver.asMockable(), function.name)
    fun <P1, P2, R, F> function(function: F, type: KFunction2<P1, P2>): VerifyFunction2Builder<P1, P2> where F : (P1, P2) -> R, F : KFunction<R> = VerifyFunction2Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, R, F> function(function: F): VerifyFunction3Builder<P1, P2, P3> where F : (P1, P2, P3) -> R, F : KFunction<R> = VerifyFunction3Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, R, F> function(function: F, type: KFunction3<P1, P2, P3>): VerifyFunction3Builder<P1, P2, P3> where F : (P1, P2, P3) -> R, F : KFunction<R> = VerifyFunction3Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, R, F> function(function: F): VerifyFunction4Builder<P1, P2, P3, P4> where F : (P1, P2, P3, P4) -> R, F : KFunction<R> = VerifyFunction4Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, R, F> function(function: F, type: KFunction4<P1, P2, P3, P4>): VerifyFunction4Builder<P1, P2, P3, P4> where F : (P1, P2, P3, P4) -> R, F : KFunction<R> = VerifyFunction4Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, P5, R, F> function(function: F): VerifyFunction5Builder<P1, P2, P3, P4, P5> where F : (P1, P2, P3, P4, P5) -> R, F : KFunction<R> = VerifyFunction5Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, P5, R, F> function(function: F, type: KFunction5<P1, P2, P3, P4, P5>): VerifyFunction5Builder<P1, P2, P3, P4, P5> where F : (P1, P2, P3, P4, P5) -> R, F : KFunction<R> = VerifyFunction5Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, P5, P6, R, F> function(function: F): VerifyFunction6Builder<P1, P2, P3, P4, P5, P6> where F : (P1, P2, P3, P4, P5, P6) -> R, F : KFunction<R> = VerifyFunction6Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, P5, P6, R, F> function(function: F, type: KFunction6<P1, P2, P3, P4, P5, P6>): VerifyFunction6Builder<P1, P2, P3, P4, P5, P6> where F : (P1, P2, P3, P4, P5, P6) -> R, F : KFunction<R> = VerifyFunction6Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, P5, P6, P7, R, F> function(function: F): VerifyFunction7Builder<P1, P2, P3, P4, P5, P6, P7> where F : (P1, P2, P3, P4, P5, P6, P7) -> R, F : KFunction<R> = VerifyFunction7Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, P5, P6, P7, R, F> function(function: F, type: KFunction7<P1, P2, P3, P4, P5, P6, P7>): VerifyFunction7Builder<P1, P2, P3, P4, P5, P6, P7> where F : (P1, P2, P3, P4, P5, P6, P7) -> R, F : KFunction<R> = VerifyFunction7Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, P5, P6, P7, P8, R, F> function(function: F): VerifyFunction8Builder<P1, P2, P3, P4, P5, P6, P7, P8> where F : (P1, P2, P3, P4, P5, P6, P7, P8) -> R, F : KFunction<R> = VerifyFunction8Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, R, F> function(function: F, type: KFunction8<P1, P2, P3, P4, P5, P6, P7, P8>): VerifyFunction8Builder<P1, P2, P3, P4, P5, P6, P7, P8> where F : (P1, P2, P3, P4, P5, P6, P7, P8) -> R, F : KFunction<R> = VerifyFunction8Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, P5, P6, P7, P8, P9, R, F> function(function: F): VerifyFunction9Builder<P1, P2, P3, P4, P5, P6, P7, P8, P9> where F : (P1, P2, P3, P4, P5, P6, P7, P8, P9) -> R, F : KFunction<R> = VerifyFunction9Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, P9, R, F> function(function: F, type: KFunction9<P1, P2, P3, P4, P5, P6, P7, P8, P9>): VerifyFunction9Builder<P1, P2, P3, P4, P5, P6, P7, P8, P9> where F : (P1, P2, P3, P4, P5, P6, P7, P8, P9) -> R, F : KFunction<R> = VerifyFunction9Builder(receiver.asMockable(), function.name)


    fun suspendFunction(function: String): VerifyFunctionBuilder = VerifyFunctionBuilder(receiver.asMockable(), function)

    fun <R, F> suspendFunction(function: F): Verification where F : suspend () -> R, F : KFunction<R> = Verification(receiver.asMockable(), Expectation.Function(function.name, SpecificArgumentsMatcher(emptyList())))
    fun <R, F> suspendFunction(function: F, type: KFunction0): Verification where F : suspend () -> R, F : KFunction<R> = Verification(receiver.asMockable(), Expectation.Function(function.name, SpecificArgumentsMatcher(emptyList())))

    fun <P1, R, F> suspendFunction(function: F): VerifyFunction1Builder<P1> where F : suspend (P1) -> R, F : KFunction<R> = VerifyFunction1Builder(receiver.asMockable(), function.name)
    fun <P1, R, F> suspendFunction(function: F, type: KFunction1<P1>): VerifyFunction1Builder<P1> where F : suspend (P1) -> R, F : KFunction<R> = VerifyFunction1Builder(receiver.asMockable(), function.name)

    fun <P1, P2, R, F> suspendFunction(function: F): VerifyFunction2Builder<P1, P2> where F : suspend (P1, P2) -> R, F : KFunction<R> = VerifyFunction2Builder(receiver.asMockable(), function.name)
    fun <P1, P2, R, F> suspendFunction(function: F, type: KFunction2<P1, P2>): VerifyFunction2Builder<P1, P2> where F : suspend (P1, P2) -> R, F : KFunction<R> = VerifyFunction2Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, R, F> suspendFunction(function: F): VerifyFunction3Builder<P1, P2, P3> where F : suspend (P1, P2, P3) -> R, F : KFunction<R> = VerifyFunction3Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, R, F> suspendFunction(function: F, type: KFunction3<P1, P2, P3>): VerifyFunction3Builder<P1, P2, P3> where F : suspend (P1, P2, P3) -> R, F : KFunction<R> = VerifyFunction3Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, R, F> suspendFunction(function: F): VerifyFunction4Builder<P1, P2, P3, P4> where F : suspend (P1, P2, P3, P4) -> R, F : KFunction<R> = VerifyFunction4Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, R, F> suspendFunction(function: F, type: KFunction4<P1, P2, P3, P4>): VerifyFunction4Builder<P1, P2, P3, P4> where F : suspend (P1, P2, P3, P4) -> R, F : KFunction<R> = VerifyFunction4Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, P5, R, F> suspendFunction(function: F): VerifyFunction5Builder<P1, P2, P3, P4, P5> where F : suspend (P1, P2, P3, P4, P5) -> R, F : KFunction<R> = VerifyFunction5Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, P5, R, F> suspendFunction(function: F, type: KFunction5<P1, P2, P3, P4, P5>): VerifyFunction5Builder<P1, P2, P3, P4, P5> where F : suspend (P1, P2, P3, P4, P5) -> R, F : KFunction<R> = VerifyFunction5Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, P5, P6, R, F> suspendFunction(function: F): VerifyFunction6Builder<P1, P2, P3, P4, P5, P6> where F : suspend (P1, P2, P3, P4, P5, P6) -> R, F : KFunction<R> = VerifyFunction6Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, P5, P6, R, F> suspendFunction(function: F, type: KFunction6<P1, P2, P3, P4, P5, P6>): VerifyFunction6Builder<P1, P2, P3, P4, P5, P6> where F : suspend (P1, P2, P3, P4, P5, P6) -> R, F : KFunction<R> = VerifyFunction6Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, P5, P6, P7, R, F> suspendFunction(function: F): VerifyFunction7Builder<P1, P2, P3, P4, P5, P6, P7> where F : suspend (P1, P2, P3, P4, P5, P6, P7) -> R, F : KFunction<R> = VerifyFunction7Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, P5, P6, P7, R, F> suspendFunction(function: F, type: KFunction7<P1, P2, P3, P4, P5, P6, P7>): VerifyFunction7Builder<P1, P2, P3, P4, P5, P6, P7> where F : suspend (P1, P2, P3, P4, P5, P6, P7) -> R, F : KFunction<R> = VerifyFunction7Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, P5, P6, P7, P8, R, F> suspendFunction(function: F): VerifyFunction8Builder<P1, P2, P3, P4, P5, P6, P7, P8> where F : suspend (P1, P2, P3, P4, P5, P6, P7, P8) -> R, F : KFunction<R> = VerifyFunction8Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, R, F> suspendFunction(function: F, type: KFunction8<P1, P2, P3, P4, P5, P6, P7, P8>): VerifyFunction8Builder<P1, P2, P3, P4, P5, P6, P7, P8> where F : suspend (P1, P2, P3, P4, P5, P6, P7, P8) -> R, F : KFunction<R> = VerifyFunction8Builder(receiver.asMockable(), function.name)

    fun <P1, P2, P3, P4, P5, P6, P7, P8, P9, R, F> suspendFunction(function: F): VerifyFunction9Builder<P1, P2, P3, P4, P5, P6, P7, P8, P9> where F : suspend (P1, P2, P3, P4, P5, P6, P7, P8, P9) -> R, F : KFunction<R> = VerifyFunction9Builder(receiver.asMockable(), function.name)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, P9, R, F> suspendFunction(function: F, type: KFunction9<P1, P2, P3, P4, P5, P6, P7, P8, P9>): VerifyFunction9Builder<P1, P2, P3, P4, P5, P6, P7, P8, P9> where F : suspend (P1, P2, P3, P4, P5, P6, P7, P8, P9) -> R, F : KFunction<R> = VerifyFunction9Builder(receiver.asMockable(), function.name)


    fun hasNoUnverifiedExpectations() = receiver.asMockable().confirmVerified()

    fun hasNoUnmetExpectations() = receiver.asMockable().verifyNoUnmetExpectations()
}