package io.mockative

import io.mockative.matchers.Matcher
import io.mockative.matchers.SpecificArgumentsMatcher

class VerifyFunction6Builder<P1, P2, P3, P4, P5, P6>(private val receiver: Mockable, private val function: String) {
    fun with(p1: Matcher<P1>, p2: Matcher<P2>, p3: Matcher<P3>, p4: Matcher<P4>, p5: Matcher<P5>, p6: Matcher<P6>): Verification {
        val matcher = SpecificArgumentsMatcher(listOf(p1, p2, p3, p4, p5, p6))
        return Verification(receiver, Expectation.Function(function, matcher))
    }
}