package io.mockative

import kotlin.reflect.KFunction
import kotlin.reflect.KProperty
import kotlin.reflect.KMutableProperty

class GivenBuilder<T : Any>(private val receiver: T) {
    suspend fun <R> coroutine(block: suspend T.() -> R): SuspendResultBuilder<R> {
        val mock = receiver.asMockable()
        val invocation = mock.record(block)
        val expectation = invocation.toExpectation()
        return SuspendResultBuilder(mock, expectation)
    }

    fun <R> invocation(block: T.() -> R): ResultBuilder<R> {
        val mock = receiver.asMockable()
        val invocation = mock.record(block)
        val expectation = invocation.toExpectation()
        return ResultBuilder(mock, expectation)
    }

    fun <V> getter(property: KProperty<V>): GivenGetterBuilder<V> = GivenGetterBuilder(receiver.asMockable(), property.name)
    fun <V> getter(property: String): GivenGetterBuilder<V> = GivenGetterBuilder(receiver.asMockable(), property)

    fun <V> setter(property: KMutableProperty<V>): GivenSetterBuilder<V> = GivenSetterBuilder(receiver.asMockable(), property.name)
    fun <V> setter(property: String): GivenSetterBuilder<V> = GivenSetterBuilder(receiver.asMockable(), property)

    fun <R, F> function(function: F): GivenFunction0Builder<R> where F : () -> R, F : KFunction<R> = GivenFunction0Builder(receiver.asMockable(), function)
    fun <R, F> function(function: F, @Suppress("unused") type: KFunction0): GivenFunction0Builder<R> where F : () -> R, F : KFunction<R> = GivenFunction0Builder(receiver.asMockable(), function)
    fun <P1, R, F> function(function: F): GivenFunction1Builder<P1, R> where F : (P1) -> R, F : KFunction<R> = GivenFunction1Builder(receiver.asMockable(), function)
    fun <P1, R, F> function(function: F, @Suppress("unused") type: KFunction1<P1>): GivenFunction1Builder<P1, R> where F : (P1) -> R, F : KFunction<R> = GivenFunction1Builder(receiver.asMockable(), function)
    fun <P1, P2, R, F> function(function: F): GivenFunction2Builder<P1, P2, R> where F : (P1, P2) -> R, F : KFunction<R> = GivenFunction2Builder(receiver.asMockable(), function)
    fun <P1, P2, R, F> function(function: F, @Suppress("unused") type: KFunction2<P1, P2>): GivenFunction2Builder<P1, P2, R> where F : (P1, P2) -> R, F : KFunction<R> = GivenFunction2Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, R, F> function(function: F): GivenFunction3Builder<P1, P2, P3, R> where F : (P1, P2, P3) -> R, F : KFunction<R> = GivenFunction3Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, R, F> function(function: F, @Suppress("unused") type: KFunction3<P1, P2, P3>): GivenFunction3Builder<P1, P2, P3, R> where F : (P1, P2, P3) -> R, F : KFunction<R> = GivenFunction3Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, R, F> function(function: F): GivenFunction4Builder<P1, P2, P3, P4, R> where F : (P1, P2, P3, P4) -> R, F : KFunction<R> = GivenFunction4Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, R, F> function(function: F, @Suppress("unused") type: KFunction4<P1, P2, P3, P4>): GivenFunction4Builder<P1, P2, P3, P4, R> where F : (P1, P2, P3, P4) -> R, F : KFunction<R> = GivenFunction4Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, R, F> function(function: F): GivenFunction5Builder<P1, P2, P3, P4, P5, R> where F : (P1, P2, P3, P4, P5) -> R, F : KFunction<R> = GivenFunction5Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, R, F> function(function: F, @Suppress("unused") type: KFunction5<P1, P2, P3, P4, P5>): GivenFunction5Builder<P1, P2, P3, P4, P5, R> where F : (P1, P2, P3, P4, P5) -> R, F : KFunction<R> = GivenFunction5Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, R, F> function(function: F): GivenFunction6Builder<P1, P2, P3, P4, P5, P6, R> where F : (P1, P2, P3, P4, P5, P6) -> R, F : KFunction<R> = GivenFunction6Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, R, F> function(function: F, @Suppress("unused") type: KFunction6<P1, P2, P3, P4, P5, P6>): GivenFunction6Builder<P1, P2, P3, P4, P5, P6, R> where F : (P1, P2, P3, P4, P5, P6) -> R, F : KFunction<R> = GivenFunction6Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, R, F> function(function: F): GivenFunction7Builder<P1, P2, P3, P4, P5, P6, P7, R> where F : (P1, P2, P3, P4, P5, P6, P7) -> R, F : KFunction<R> = GivenFunction7Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, R, F> function(function: F, @Suppress("unused") type: KFunction7<P1, P2, P3, P4, P5, P6, P7>): GivenFunction7Builder<P1, P2, P3, P4, P5, P6, P7, R> where F : (P1, P2, P3, P4, P5, P6, P7) -> R, F : KFunction<R> = GivenFunction7Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, R, F> function(function: F): GivenFunction8Builder<P1, P2, P3, P4, P5, P6, P7, P8, R> where F : (P1, P2, P3, P4, P5, P6, P7, P8) -> R, F : KFunction<R> = GivenFunction8Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, R, F> function(function: F, @Suppress("unused") type: KFunction8<P1, P2, P3, P4, P5, P6, P7, P8>): GivenFunction8Builder<P1, P2, P3, P4, P5, P6, P7, P8, R> where F : (P1, P2, P3, P4, P5, P6, P7, P8) -> R, F : KFunction<R> = GivenFunction8Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, P9, R, F> function(function: F): GivenFunction9Builder<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> where F : (P1, P2, P3, P4, P5, P6, P7, P8, P9) -> R, F : KFunction<R> = GivenFunction9Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, P9, R, F> function(function: F, @Suppress("unused") type: KFunction9<P1, P2, P3, P4, P5, P6, P7, P8, P9>): GivenFunction9Builder<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> where F : (P1, P2, P3, P4, P5, P6, P7, P8, P9) -> R, F : KFunction<R> = GivenFunction9Builder(receiver.asMockable(), function)


    fun <R, F> suspendFunction(function: F): GivenSuspendFunction0Builder<R> where F : suspend () -> R, F : KFunction<R> = GivenSuspendFunction0Builder(receiver.asMockable(), function)
    fun <R, F> suspendFunction(function: F, @Suppress("unused") type: KFunction0): GivenSuspendFunction0Builder<R> where F : suspend () -> R, F : KFunction<R> = GivenSuspendFunction0Builder(receiver.asMockable(), function)
    fun <P1, R, F> suspendFunction(function: F): GivenSuspendFunction1Builder<P1, R> where F : suspend (P1) -> R, F : KFunction<R> = GivenSuspendFunction1Builder(receiver.asMockable(), function)
    fun <P1, R, F> suspendFunction(function: F, @Suppress("unused") type: KFunction1<P1>): GivenSuspendFunction1Builder<P1, R> where F : suspend (P1) -> R, F : KFunction<R> = GivenSuspendFunction1Builder(receiver.asMockable(), function)
    fun <P1, P2, R, F> suspendFunction(function: F): GivenSuspendFunction2Builder<P1, P2, R> where F : suspend (P1, P2) -> R, F : KFunction<R> = GivenSuspendFunction2Builder(receiver.asMockable(), function)
    fun <P1, P2, R, F> suspendFunction(function: F, @Suppress("unused") type: KFunction2<P1, P2>): GivenSuspendFunction2Builder<P1, P2, R> where F : suspend (P1, P2) -> R, F : KFunction<R> = GivenSuspendFunction2Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, R, F> suspendFunction(function: F): GivenSuspendFunction3Builder<P1, P2, P3, R> where F : suspend (P1, P2, P3) -> R, F : KFunction<R> = GivenSuspendFunction3Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, R, F> suspendFunction(function: F, @Suppress("unused") type: KFunction3<P1, P2, P3>): GivenSuspendFunction3Builder<P1, P2, P3, R> where F : suspend (P1, P2, P3) -> R, F : KFunction<R> = GivenSuspendFunction3Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, R, F> suspendFunction(function: F): GivenSuspendFunction4Builder<P1, P2, P3, P4, R> where F : suspend (P1, P2, P3, P4) -> R, F : KFunction<R> = GivenSuspendFunction4Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, R, F> suspendFunction(function: F, @Suppress("unused") type: KFunction4<P1, P2, P3, P4>): GivenSuspendFunction4Builder<P1, P2, P3, P4, R> where F : suspend (P1, P2, P3, P4) -> R, F : KFunction<R> = GivenSuspendFunction4Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, R, F> suspendFunction(function: F): GivenSuspendFunction5Builder<P1, P2, P3, P4, P5, R> where F : suspend (P1, P2, P3, P4, P5) -> R, F : KFunction<R> = GivenSuspendFunction5Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, R, F> suspendFunction(function: F, @Suppress("unused") type: KFunction5<P1, P2, P3, P4, P5>): GivenSuspendFunction5Builder<P1, P2, P3, P4, P5, R> where F : suspend (P1, P2, P3, P4, P5) -> R, F : KFunction<R> = GivenSuspendFunction5Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, R, F> suspendFunction(function: F): GivenSuspendFunction6Builder<P1, P2, P3, P4, P5, P6, R> where F : suspend (P1, P2, P3, P4, P5, P6) -> R, F : KFunction<R> = GivenSuspendFunction6Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, R, F> suspendFunction(function: F, @Suppress("unused") type: KFunction6<P1, P2, P3, P4, P5, P6>): GivenSuspendFunction6Builder<P1, P2, P3, P4, P5, P6, R> where F : suspend (P1, P2, P3, P4, P5, P6) -> R, F : KFunction<R> = GivenSuspendFunction6Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, R, F> suspendFunction(function: F): GivenSuspendFunction7Builder<P1, P2, P3, P4, P5, P6, P7, R> where F : suspend (P1, P2, P3, P4, P5, P6, P7) -> R, F : KFunction<R> = GivenSuspendFunction7Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, R, F> suspendFunction(function: F, @Suppress("unused") type: KFunction7<P1, P2, P3, P4, P5, P6, P7>): GivenSuspendFunction7Builder<P1, P2, P3, P4, P5, P6, P7, R> where F : suspend (P1, P2, P3, P4, P5, P6, P7) -> R, F : KFunction<R> = GivenSuspendFunction7Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, R, F> suspendFunction(function: F): GivenSuspendFunction8Builder<P1, P2, P3, P4, P5, P6, P7, P8, R> where F : suspend (P1, P2, P3, P4, P5, P6, P7, P8) -> R, F : KFunction<R> = GivenSuspendFunction8Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, R, F> suspendFunction(function: F, @Suppress("unused") type: KFunction8<P1, P2, P3, P4, P5, P6, P7, P8>): GivenSuspendFunction8Builder<P1, P2, P3, P4, P5, P6, P7, P8, R> where F : suspend (P1, P2, P3, P4, P5, P6, P7, P8) -> R, F : KFunction<R> = GivenSuspendFunction8Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, P9, R, F> suspendFunction(function: F): GivenSuspendFunction9Builder<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> where F : suspend (P1, P2, P3, P4, P5, P6, P7, P8, P9) -> R, F : KFunction<R> = GivenSuspendFunction9Builder(receiver.asMockable(), function)
    fun <P1, P2, P3, P4, P5, P6, P7, P8, P9, R, F> suspendFunction(function: F, @Suppress("unused") type: KFunction9<P1, P2, P3, P4, P5, P6, P7, P8, P9>): GivenSuspendFunction9Builder<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> where F : suspend (P1, P2, P3, P4, P5, P6, P7, P8, P9) -> R, F : KFunction<R> = GivenSuspendFunction9Builder(receiver.asMockable(), function)

}