package io.mockative

import io.mockative.matchers.Matcher
import io.mockative.matchers.SpecificArgumentsMatcher

class VerifyFunction7Builder<P1, P2, P3, P4, P5, P6, P7>(private val receiver: Mockable, private val function: String) {
    fun with(p1: Matcher<P1> = anything(), p2: Matcher<P2> = anything(), p3: Matcher<P3> = anything(), p4: Matcher<P4> = anything(), p5: Matcher<P5> = anything(), p6: Matcher<P6> = anything(), p7: Matcher<P7> = anything()): Verification {
        val matcher = SpecificArgumentsMatcher(listOf(p1, p2, p3, p4, p5, p6, p7))
        return Verification(receiver, Expectation.Function(function, matcher))
    }
}