package io.mockative

import io.mockative.matchers.ArgumentsMatcher
import io.mockative.matchers.Matcher
import io.mockative.matchers.SpecificArgumentsMatcher
import kotlin.reflect.KFunction

class GivenSuspendFunction8Builder<P1, P2, P3, P4, P5, P6, P7, P8, R>(private val mock: Mockable, private val function: KFunction<R>) {
    fun whenInvokedWith(p1: Matcher<P1>, p2: Matcher<P2>, p3: Matcher<P3>, p4: Matcher<P4>, p5: Matcher<P5>, p6: Matcher<P6>, p7: Matcher<P7>, p8: Matcher<P8>): ResultBuilder {
        val arguments = SpecificArgumentsMatcher(listOf(p1, p2, p3, p4, p5, p6, p7, p8))
        return ResultBuilder(arguments)
    }

    @Suppress("UNCHECKED_CAST")
    inner class ResultBuilder(private val arguments: ArgumentsMatcher) : AnySuspendResultBuilder<R> {
        fun then(block: suspend (P1, P2, P3, P4, P5, P6, P7, P8) -> R) {
            val expectation = Expectation.Function(function.name, arguments)
            val stub = SuspendStub(expectation) { args ->
                block(args[0] as P1, args[1] as P2, args[2] as P3, args[3] as P4, args[4] as P5, args[5] as P6, args[6] as P7, args[7] as P8)
            }
            mock.addSuspendStub(stub)
        }

        override fun thenInvoke(block: suspend () -> R) = then { _, _, _, _, _, _, _, _ -> block() }
    }
}