package io.mockative

import io.mockative.matchers.Matcher
import io.mockative.matchers.SpecificArgumentsMatcher

class VerifyFunction8Builder<P1, P2, P3, P4, P5, P6, P7, P8>(private val receiver: Mockable, private val function: String) {
    fun with(p1: Matcher<P1>, p2: Matcher<P2>, p3: Matcher<P3>, p4: Matcher<P4>, p5: Matcher<P5>, p6: Matcher<P6>, p7: Matcher<P7>, p8: Matcher<P8>): Verification {
        val matcher = SpecificArgumentsMatcher(listOf(p1, p2, p3, p4, p5, p6, p7, p8))
        return Verification(receiver, Expectation.Function(function, matcher))
    }
}