package io.mockative

import io.mockative.matchers.ArgumentsMatcher
import io.mockative.matchers.Matcher
import io.mockative.matchers.SpecificArgumentsMatcher
import kotlin.reflect.KFunction

class GivenFunction1Builder<P1, R>(private val mock: Mockable, private val function: KFunction<R>) {
    fun whenInvokedWith(p1: Matcher<P1>): ResultBuilder {
        val arguments = SpecificArgumentsMatcher(listOf(p1))
        return ResultBuilder(arguments)
    }

    @Suppress("UNCHECKED_CAST")
    inner class ResultBuilder(private val arguments: ArgumentsMatcher) : AnyResultBuilder<R> {
        fun then(block: (P1) -> R) {
            val expectation = Expectation.Function(function.name, arguments)
            val stub = BlockingStub(expectation) { args ->
                block(args[0] as P1)
            }
            mock.addBlockingStub(stub)
        }

        override fun thenInvoke(block: () -> R) = then { _ -> block() }
    }
}