/*
 * Decompiled with CFR 0.152.
 */
package io.mindmaps.graql;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import io.mindmaps.graql.GraqlClient;
import io.mindmaps.graql.GraqlClientImpl;
import io.mindmaps.graql.internal.shell.ErrorMessage;
import io.mindmaps.graql.internal.shell.GraQLCompleter;
import io.mindmaps.graql.internal.shell.GraqlSignalHandler;
import io.mindmaps.graql.internal.shell.ShellCommandCompleter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import jline.console.ConsoleReader;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.Completer;
import jline.console.history.FileHistory;
import jline.console.history.History;
import mjson.Json;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import sun.misc.Signal;

@WebSocket
public class GraqlShell {
    private static final String LICENSE_PROMPT = "\nMindmapsDB  Copyright (C) 2016  Mindmaps Research Ltd \nThis is free software, and you are welcome to redistribute it \nunder certain conditions; type 'license' for details.\n";
    private static final String LICENSE_LOCATION = "LICENSE.txt";
    private static final String DEFAULT_NAMESPACE = "mindmaps";
    private static final String DEFAULT_URI = "localhost:4567";
    private static final String PROMPT = ">>> ";
    private static final String EDIT_COMMAND = "edit";
    private static final String COMMIT_COMMAND = "commit";
    private static final String ROLLBACK_COMMAND = "rollback";
    private static final String LOAD_COMMAND = "load";
    private static final String CLEAR_COMMAND = "clear";
    private static final String EXIT_COMMAND = "exit";
    private static final String LICENSE_COMMAND = "license";
    private static final int QUERY_CHUNK_SIZE = 1000;
    private static final int PING_INTERVAL = 60000;
    public static final String[] COMMANDS = new String[]{"edit", "rollback", "commit", "load", "clear", "exit"};
    private static final String TEMP_FILENAME = "/graql-tmp.gql";
    private static final String HISTORY_FILENAME = "/graql-history";
    private static final String DEFAULT_EDITOR = "vim";
    private final File tempFile = new File(System.getProperty("java.io.tmpdir") + "/graql-tmp.gql");
    private ConsoleReader console;
    private final String historyFilename;
    private Session session;
    private CompletableFuture<Json> autocompleteResponse = new CompletableFuture();
    private boolean waitingQuery = false;
    private Optional<List<String>> queryStrings;

    public static void main(String[] args) {
        GraqlShell.runShell(args, "0.4.0", HISTORY_FILENAME, new GraqlClientImpl());
    }

    public static void runShell(String[] args, String version, String historyFilename, GraqlClient client) {
        CommandLine cmd;
        Options options = new Options();
        options.addOption("n", "name", true, "name of the graph");
        options.addOption("e", "execute", true, "query to execute");
        options.addOption("f", "file", true, "graql file path to execute");
        options.addOption("u", "uri", true, "uri to factory to engine");
        options.addOption("b", "batch", true, "graql file path to batch load");
        options.addOption("h", "help", false, "print usage message");
        options.addOption("v", "version", false, "print version");
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return;
        }
        Optional<List<String>> queries = Optional.ofNullable(cmd.getOptionValue("e")).map(xva$0 -> Lists.newArrayList((Object[])new String[]{xva$0}));
        String[] filePaths = cmd.getOptionValues("f");
        if (cmd.hasOption("h") || !cmd.getArgList().isEmpty()) {
            HelpFormatter helpFormatter = new HelpFormatter();
            PrintWriter printWriter = new PrintWriter(System.out);
            int width = helpFormatter.getWidth();
            int leftPadding = helpFormatter.getLeftPadding();
            int descPadding = helpFormatter.getDescPadding();
            helpFormatter.printHelp(printWriter, width, "graql.sh", null, options, leftPadding, descPadding, null);
            printWriter.flush();
            return;
        }
        if (cmd.hasOption("v")) {
            System.out.println(version);
            return;
        }
        String namespace = cmd.getOptionValue("n", DEFAULT_NAMESPACE);
        String uriString = cmd.getOptionValue("u", DEFAULT_URI);
        if (cmd.hasOption("b")) {
            try {
                GraqlShell.sendBatchRequest(uriString, cmd.getOptionValue("b"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        try {
            if (filePaths != null) {
                queries = Optional.of(GraqlShell.loadQueries(filePaths));
            }
            URI uri = new URI("ws://" + uriString + "/shell/remote");
            new GraqlShell(historyFilename, namespace, client, uri, queries);
        }
        catch (ConnectException e) {
            System.err.println(ErrorMessage.COULD_NOT_CONNECT.getMessage(new Object[0]));
        }
        catch (Throwable e) {
            System.err.println(e.toString());
        }
    }

    private static List<String> loadQueries(String[] filePaths) throws IOException {
        ArrayList queries = Lists.newArrayList();
        for (String filePath : filePaths) {
            queries.add(GraqlShell.loadQuery(filePath));
        }
        return queries;
    }

    private static String loadQuery(String filePath) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8);
        return lines.stream().collect(Collectors.joining("\n"));
    }

    private static void sendBatchRequest(String uriString, String graqlPath) throws IOException {
        InputStream is;
        byte[] out = ("{\"path\": \"" + StringEscapeUtils.escapeJavaScript((String)graqlPath) + "\"}").getBytes(StandardCharsets.UTF_8);
        URL url = new URL("http://" + uriString + "/import/batch/data");
        URLConnection con = url.openConnection();
        HttpURLConnection http = (HttpURLConnection)con;
        http.setRequestMethod("POST");
        http.setDoOutput(true);
        http.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        http.setFixedLengthStreamingMode(out.length);
        http.connect();
        try (OutputStream os = http.getOutputStream();){
            os.write(out);
        }
        int statusCode = http.getResponseCode();
        if (statusCode >= 200 && statusCode < 400) {
            is = http.getInputStream();
            Throwable throwable = null;
            try {
                String response = CharStreams.toString((Readable)new InputStreamReader(is, Charsets.UTF_8));
                System.out.println(response);
            }
            catch (Throwable response) {
                throwable = response;
                throw response;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable response) {
                            throwable.addSuppressed(response);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        is = http.getErrorStream();
        Throwable throwable = null;
        try {
            String response = CharStreams.toString((Readable)new InputStreamReader(is, Charsets.UTF_8));
            System.out.println(response);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (is != null) {
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    is.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraqlShell(String historyFilename, String namespace, GraqlClient client, URI uri, Optional<List<String>> queryStrings) throws Throwable {
        this.historyFilename = historyFilename;
        try {
            this.console = new ConsoleReader(System.in, (OutputStream)System.out);
            Signal signal = new Signal("INT");
            GraqlSignalHandler signalHandler = new GraqlSignalHandler(this);
            Signal.handle(signal, signalHandler);
            try {
                this.session = client.connect(this, uri).get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            this.sendJson(Json.object((Object[])new Object[]{"action", "namespace", "namespace", namespace}));
            this.start(queryStrings);
        }
        finally {
            client.close();
            this.console.flush();
        }
    }

    private void start(Optional<List<String>> queryStrings) throws IOException {
        Thread thread = new Thread(this::ping);
        thread.setDaemon(true);
        thread.start();
        if (queryStrings.isPresent()) {
            queryStrings.get().forEach(queryString -> {
                this.executeQuery((String)queryString);
                this.commit();
            });
        } else {
            this.executeRepl();
        }
    }

    void executeRepl() throws IOException {
        String queryString;
        boolean success;
        this.console.print((CharSequence)LICENSE_PROMPT);
        this.console.setExpandEvents(false);
        this.console.setPrompt(PROMPT);
        if (!this.tempFile.exists() && !(success = this.tempFile.createNewFile())) {
            this.print(ErrorMessage.COULD_NOT_CREATE_TEMP_FILE.getMessage(new Object[0]));
        }
        File historyFile = new File(System.getProperty("java.io.tmpdir") + this.historyFilename);
        historyFile.createNewFile();
        FileHistory history = new FileHistory(historyFile);
        this.console.setHistory((History)history);
        this.console.addCompleter((Completer)new AggregateCompleter(new Completer[]{new GraQLCompleter(this), new ShellCommandCompleter()}));
        block20: while ((queryString = this.console.readLine()) != null) {
            history.flush();
            switch (queryString) {
                case "edit": {
                    this.executeQuery(this.runEditor());
                    continue block20;
                }
                case "commit": {
                    this.commit();
                    continue block20;
                }
                case "rollback": {
                    this.rollback();
                    continue block20;
                }
                case "clear": {
                    this.console.clearScreen();
                    continue block20;
                }
                case "license": {
                    this.printLicense();
                    continue block20;
                }
                case "exit": {
                    return;
                }
                case "": {
                    continue block20;
                }
            }
            if (queryString.startsWith("load ")) {
                String path = queryString.substring(LOAD_COMMAND.length() + 1);
                try {
                    queryString = GraqlShell.loadQuery(path);
                }
                catch (IOException e) {
                    System.err.println(e.toString());
                    continue;
                }
            }
            this.executeQuery(queryString);
        }
    }

    private void printLicense() {
        StringBuilder result = new StringBuilder("");
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream is = classloader.getResourceAsStream(LICENSE_LOCATION);
        Scanner scanner = new Scanner(is);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            result.append(line).append("\n");
        }
        result.append("\n");
        scanner.close();
        this.print(result.toString());
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) throws IOException, ExecutionException, InterruptedException {
        if (statusCode != 1000) {
            System.err.println("Websocket closed, code: " + statusCode + ", reason: " + reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketMessage
    public void onMessage(String msg) {
        Json json = Json.read((String)msg);
        switch (json.at("action").asString()) {
            case "query": {
                String result = json.at("result").asString();
                this.print(result);
                break;
            }
            case "queryEnd": {
                GraqlShell graqlShell = this;
                synchronized (graqlShell) {
                    this.notifyAll();
                    break;
                }
            }
            case "autocomplete": {
                this.autocompleteResponse.complete(json);
                break;
            }
            case "error": {
                System.err.print(json.at("error").asString());
            }
        }
    }

    private void ping() {
        try {
            while (true) {
                this.sendJson(Json.object((Object[])new Object[]{"action", "ping"}));
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (WebSocketException e) {
            if (this.session.isOpen()) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(String queryString) {
        try {
            Iterable splitQuery = Splitter.fixedLength((int)1000).split((CharSequence)queryString);
            for (String queryChunk : splitQuery) {
                this.sendJson(Json.object((Object[])new Object[]{"action", "query", "query", queryChunk}));
            }
            this.sendJson(Json.object((Object[])new Object[]{"action", "queryEnd"}));
            this.waitingQuery = true;
            GraqlShell graqlShell = this;
            synchronized (graqlShell) {
                this.wait();
            }
            this.waitingQuery = false;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void commit() {
        this.sendJson(Json.object((Object[])new Object[]{"action", COMMIT_COMMAND}));
    }

    private void rollback() {
        this.sendJson(Json.object((Object[])new Object[]{"action", ROLLBACK_COMMAND}));
    }

    private String runEditor() throws IOException {
        Map<String, String> env = System.getenv();
        String editor = Optional.ofNullable(env.get("EDITOR")).orElse(DEFAULT_EDITOR);
        ProcessBuilder builder = new ProcessBuilder("/bin/bash", "-c", editor + " </dev/tty >/dev/tty " + this.tempFile.getAbsolutePath());
        try {
            builder.start().waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return String.join((CharSequence)"\n", Files.readAllLines(this.tempFile.toPath()));
    }

    public void interrupt() {
        if (this.waitingQuery) {
            this.sendJson(Json.object((Object[])new Object[]{"action", "queryAbort"}));
            this.waitingQuery = false;
        } else {
            System.exit(0);
        }
    }

    public synchronized Json getAutocompleteCandidates(String queryString, int cursorPosition) throws InterruptedException, ExecutionException, IOException {
        this.sendJson(Json.object((Object[])new Object[]{"action", "autocomplete", "query", queryString, "cursor", cursorPosition}));
        Json json = this.autocompleteResponse.get();
        this.autocompleteResponse = new CompletableFuture();
        return json;
    }

    private void sendJson(Json json) {
        try {
            this.session.getRemote().sendString(json.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void print(String string) {
        try {
            this.console.print((CharSequence)string);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

