/*
 * Decompiled with CFR 0.152.
 */
package io.mindmaps.migration.export;

import io.mindmaps.concept.EntityType;
import io.mindmaps.concept.RelationType;
import io.mindmaps.concept.ResourceType;
import io.mindmaps.concept.RoleType;
import io.mindmaps.concept.RuleType;
import io.mindmaps.concept.Type;
import io.mindmaps.graql.Graql;
import io.mindmaps.graql.Var;

public class TypeMapper {
    public static String map(Type type) {
        Var mapped = TypeMapper.formatBase(type);
        if (type instanceof EntityType) {
            mapped = TypeMapper.map(mapped, type.asEntityType());
        } else if (type instanceof RelationType) {
            mapped = TypeMapper.map(mapped, type.asRelationType());
        } else if (type instanceof RoleType) {
            mapped = TypeMapper.map(mapped, type.asRoleType());
        } else if (type instanceof ResourceType) {
            mapped = TypeMapper.map(mapped, type.asResourceType());
        } else if (type instanceof RuleType) {
            mapped = TypeMapper.map(mapped, type.asRuleType());
        }
        return mapped.toString();
    }

    public static Var map(Var var, EntityType entityType) {
        return var;
    }

    public static Var map(Var var, RelationType relationType) {
        return TypeMapper.hasRoles(var, relationType);
    }

    public static Var map(Var var, RoleType roleType) {
        return var;
    }

    public static Var map(Var var, ResourceType resourceType) {
        return TypeMapper.datatype(var, resourceType);
    }

    public static Var map(Var var, RuleType ruleType) {
        return var;
    }

    private static Var formatBase(Type type) {
        Var var = Graql.var().id(type.getId()).isa(type.type().getId());
        var = TypeMapper.playsRoles(var, type);
        var = TypeMapper.isAbstract(var, type);
        return var;
    }

    private static Var isAbstract(Var var, Type type) {
        return type.isAbstract() != false ? var.isAbstract() : var;
    }

    private static Var playsRoles(Var var, Type type) {
        for (RoleType role : type.playsRoles()) {
            var = var.playsRole(role.getId());
        }
        return var;
    }

    private static Var hasRoles(Var var, RelationType type) {
        for (RoleType role : type.hasRoles()) {
            var = var.hasRole(role.getId());
        }
        return var;
    }

    private static Var datatype(Var var, ResourceType type) {
        return var.datatype(type.getDataType());
    }
}

