/*
 * Decompiled with CFR 0.152.
 */
package io.mindmaps.migration.export;

import io.mindmaps.Mindmaps;
import io.mindmaps.MindmapsGraph;
import io.mindmaps.migration.export.GraphWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Main {
    static void die(String errorMsg) {
        throw new RuntimeException(errorMsg + "\nSyntax: ./migration.sh export {ontology, data} -file <output file> -graph <graph name> [-engine <Mindmaps engine URL>]");
    }

    public static void main(String[] args) {
        String graphName = null;
        String outputFileName = null;
        String engineURL = null;
        boolean ontology = false;
        boolean data = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-file".equals(args[i])) {
                outputFileName = args[++i];
                continue;
            }
            if ("-graph".equals(args[i])) {
                graphName = args[++i];
                continue;
            }
            if ("-engine".equals(args[i])) {
                engineURL = args[++i];
                continue;
            }
            if (i == 1 && "ontology".equals(args[i])) {
                ontology = true;
                continue;
            }
            if (i == 1 && "data".equals(args[i])) {
                data = true;
                continue;
            }
            if (i == 0 && "export".equals(args[i])) continue;
            Main.die("Unknown option " + args[i]);
        }
        String string = engineURL = engineURL == null ? "localhost:4567" : engineURL;
        if (graphName == null) {
            Main.die("You must provide a graph name argument using -graph");
        }
        System.out.println("Writing graph " + graphName + " using MM Engine " + engineURL + " to file " + (outputFileName == null ? "System.out" : outputFileName));
        MindmapsGraph graph = Mindmaps.factory((String)engineURL, (String)graphName).getGraph();
        GraphWriter writer = new GraphWriter(graph);
        String contents = null;
        if (ontology) {
            contents = writer.dumpOntology();
        } else if (data) {
            contents = writer.dumpData();
        }
        if (outputFileName == null) {
            System.out.println(contents);
            return;
        }
        try {
            File outputFile = new File(outputFileName);
            outputFile.createNewFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(outputFile));
            bufferedWriter.write(contents);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException e) {
            Main.die("Problem writing to file " + outputFileName);
        }
    }
}

