/*
 * Decompiled with CFR 0.152.
 */
package io.mindmaps.migration.export;

import io.mindmaps.concept.Concept;
import io.mindmaps.concept.Entity;
import io.mindmaps.concept.Instance;
import io.mindmaps.concept.Relation;
import io.mindmaps.concept.Resource;
import io.mindmaps.concept.ResourceType;
import io.mindmaps.concept.RoleType;
import io.mindmaps.concept.Rule;
import io.mindmaps.graql.Graql;
import io.mindmaps.graql.Var;
import java.util.Collection;
import java.util.stream.Collectors;

public class InstanceMapper {
    public static String map(Instance instance) {
        Var mapped = Graql.var();
        if (instance instanceof Entity) {
            mapped = InstanceMapper.map(instance.asEntity());
        } else if (instance instanceof Resource) {
            mapped = InstanceMapper.map(instance.asResource());
        } else if (instance instanceof Relation) {
            mapped = InstanceMapper.map(instance.asRelation());
        } else if (instance instanceof Rule) {
            mapped = InstanceMapper.map(instance.asRule());
        }
        return mapped.toString().replaceAll(" has-resource$", " \"has-resource\"").replaceAll(" has-resource ", " \"has-resource\" ");
    }

    public static Var map(Entity entity) {
        Var var = InstanceMapper.base((Instance)entity);
        var = InstanceMapper.hasResources(var, entity);
        var = var.id(entity.getId());
        return var;
    }

    public static Var map(Relation relation) {
        if (InstanceMapper.isHasResourceRelation(relation)) {
            return Graql.var();
        }
        Var var = InstanceMapper.base((Instance)relation);
        var = InstanceMapper.roleplayers(var, relation);
        return var;
    }

    public static Var map(Resource resource) {
        if (InstanceMapper.isHasResourceResource(resource)) {
            return Graql.var();
        }
        Var var = InstanceMapper.base((Instance)resource);
        var = var.value(resource.getValue());
        return var;
    }

    public static Var map(Rule rule) {
        Var var = InstanceMapper.base((Instance)rule);
        var = var.id(rule.getId());
        var = var.lhs(rule.getLHS());
        var = var.rhs(rule.getRHS());
        return var;
    }

    private static Var hasResources(Var var, Entity entity) {
        for (Resource resource : entity.resources(new ResourceType[0])) {
            var = var.has(resource.type().getId(), resource.getValue());
        }
        return var;
    }

    private static Var roleplayers(Var var, Relation relation) {
        for (RoleType role : relation.rolePlayers().keySet()) {
            var = var.rel(role.getId(), ((Instance)relation.rolePlayers().get(role)).getId());
        }
        return var;
    }

    private static Var base(Instance instance) {
        return Graql.var((String)instance.getId()).isa(instance.type().getId());
    }

    private static boolean isHasResourceRelation(Relation relation) {
        String relationType = relation.type().getId();
        if (!relationType.startsWith("has-")) {
            return false;
        }
        Collection roles = relation.rolePlayers().keySet().stream().map(Concept::getId).collect(Collectors.toSet());
        return roles.size() == 2 && roles.contains(relationType + "-value") && roles.contains(relationType + "-owner");
    }

    private static boolean isHasResourceResource(Resource resource) {
        ResourceType resourceType = resource.type();
        boolean playsRole = resourceType.playsRoles().stream().map(Concept::getId).allMatch(c -> c.equals("has-" + resourceType.getId() + "-value"));
        return !resource.ownerInstances().isEmpty() && playsRole;
    }
}

