/*
 * Decompiled with CFR 0.152.
 */
package io.mindmaps.migration.export;

import io.mindmaps.MindmapsGraph;
import io.mindmaps.concept.Concept;
import io.mindmaps.concept.Type;
import io.mindmaps.migration.export.InstanceMapper;
import io.mindmaps.migration.export.TypeMapper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GraphWriter {
    private static final String EOL = ";\n";
    private static final String INSERT = "insert\n";
    private final MindmapsGraph graph;
    private final List<String> reserved = Arrays.asList("inference-rule", "constraint-rule");

    public GraphWriter(MindmapsGraph graph) {
        this.graph = graph;
    }

    public String dumpOntology() {
        return this.joinAsInsert(this.types().map(TypeMapper::map));
    }

    public String dumpData() {
        return this.joinAsInsert(this.types().filter(t -> t.superType() == null).filter(t -> !t.isRoleType()).flatMap(c -> c.instances().stream()).map(Concept::asInstance).map(InstanceMapper::map));
    }

    private String joinAsInsert(Stream<String> stream) {
        return stream.filter(s -> !s.isEmpty()).collect(Collectors.joining(EOL, INSERT, EOL));
    }

    private Stream<Type> types() {
        return this.graph.getMetaType().instances().stream().map(Concept::asType).filter(t -> !this.reserved.contains(t.getId()));
    }
}

