/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request.ranker;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.milvus.common.clientenum.FunctionType;
import io.milvus.common.utils.JsonUtils;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WeightedRanker
extends CreateCollectionReq.Function {
    private List<Float> weights;

    @Deprecated
    public WeightedRanker(List<Float> weights) {
        super(CreateCollectionReq.Function.builder());
        this.weights = weights;
    }

    private WeightedRanker(WeightedRankerBuilder builder) {
        super(builder);
        this.weights = builder.weights;
    }

    public List<Float> getWeights() {
        return this.weights;
    }

    public void setWeights(List<Float> weights) {
        this.weights = weights;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.RERANK;
    }

    @Override
    public Map<String, String> getParams() {
        JsonObject params = new JsonObject();
        params.add("weights", (JsonElement)JsonUtils.toJsonTree(this.weights).getAsJsonArray());
        Map<String, String> props = super.getParams();
        props.put("strategy", "weighted");
        props.put("params", params.toString());
        return props;
    }

    @Override
    public String toString() {
        return "WeightedRanker{weights=" + this.weights + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", functionType=" + (Object)((Object)this.getFunctionType()) + ", inputFieldNames=" + this.getInputFieldNames() + ", outputFieldNames=" + this.getOutputFieldNames() + ", params=" + this.getParams() + '}';
    }

    public static WeightedRankerBuilder builder() {
        return new WeightedRankerBuilder();
    }

    public static class WeightedRankerBuilder
    extends CreateCollectionReq.Function.FunctionBuilder<WeightedRankerBuilder> {
        private List<Float> weights = new ArrayList<Float>();

        private WeightedRankerBuilder() {
        }

        public WeightedRankerBuilder weights(List<Float> weights) {
            this.weights = weights;
            return this;
        }

        @Override
        public WeightedRanker build() {
            return new WeightedRanker(this);
        }
    }
}

