/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request.ranker;

import io.milvus.common.clientenum.FunctionType;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.Map;

public class DecayRanker
extends CreateCollectionReq.Function {
    private String function;
    private Number origin;
    private Number offset;
    private Number scale;
    private Number decay;

    private DecayRanker(DecayRankerBuilder builder) {
        super(builder);
        this.function = builder.function;
        this.origin = builder.origin;
        this.offset = builder.offset;
        this.scale = builder.scale;
        this.decay = builder.decay;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public Number getOrigin() {
        return this.origin;
    }

    public void setOrigin(Number origin) {
        this.origin = origin;
    }

    public Number getOffset() {
        return this.offset;
    }

    public void setOffset(Number offset) {
        this.offset = offset;
    }

    public Number getScale() {
        return this.scale;
    }

    public void setScale(Number scale) {
        this.scale = scale;
    }

    public Number getDecay() {
        return this.decay;
    }

    public void setDecay(Number decay) {
        this.decay = decay;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.RERANK;
    }

    @Override
    public Map<String, String> getParams() {
        Map<String, String> props = super.getParams();
        props.put("reranker", "decay");
        props.put("function", this.function);
        if (this.origin != null) {
            props.put("origin", this.origin.toString());
        }
        if (this.offset != null) {
            props.put("offset", this.offset.toString());
        }
        if (this.scale != null) {
            props.put("scale", this.scale.toString());
        }
        if (this.decay != null) {
            props.put("decay", this.decay.toString());
        }
        return props;
    }

    @Override
    public String toString() {
        return "DecayRanker{function='" + this.function + '\'' + ", origin=" + this.origin + ", offset=" + this.offset + ", scale=" + this.scale + ", decay=" + this.decay + ", name='" + this.getName() + '\'' + ", description='" + this.getDescription() + '\'' + ", functionType=" + (Object)((Object)this.getFunctionType()) + ", inputFieldNames=" + this.getInputFieldNames() + ", outputFieldNames=" + this.getOutputFieldNames() + ", params=" + this.getParams() + '}';
    }

    public static DecayRankerBuilder builder() {
        return new DecayRankerBuilder();
    }

    public static class DecayRankerBuilder
    extends CreateCollectionReq.Function.FunctionBuilder<DecayRankerBuilder> {
        private String function = "gauss";
        private Number origin;
        private Number offset;
        private Number scale;
        private Number decay;

        private DecayRankerBuilder() {
        }

        public DecayRankerBuilder function(String function) {
            this.function = function;
            return this;
        }

        public DecayRankerBuilder origin(Number origin) {
            this.origin = origin;
            return this;
        }

        public DecayRankerBuilder offset(Number offset) {
            this.offset = offset;
            return this;
        }

        public DecayRankerBuilder scale(Number scale) {
            this.scale = scale;
            return this;
        }

        public DecayRankerBuilder decay(Number decay) {
            this.decay = decay;
            return this;
        }

        @Override
        public DecayRanker build() {
            return new DecayRanker(this);
        }
    }
}

