/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request.ranker;

import io.milvus.common.clientenum.FunctionType;
import io.milvus.common.utils.JsonUtils;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BoostRanker
extends CreateCollectionReq.Function {
    private String filter;
    private Float weight;
    private Long randomScoreSeed;
    private String randomScoreField;

    private BoostRanker(BoostRankerBuilder builder) {
        super(builder);
        this.filter = builder.filter;
        this.weight = builder.weight;
        this.randomScoreSeed = builder.randomScoreSeed;
        this.randomScoreField = builder.randomScoreField;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.RERANK;
    }

    @Override
    public Map<String, String> getParams() {
        Map<String, String> props = super.getParams();
        props.put("reranker", "boost");
        if (!StringUtils.isEmpty((CharSequence)this.filter)) {
            props.put("filter", this.filter);
        }
        if (this.weight != null) {
            props.put("weight", this.weight.toString());
        }
        HashMap<String, Object> randomScore = new HashMap<String, Object>();
        if (this.randomScoreSeed != null) {
            randomScore.put("seed", this.randomScoreSeed);
        }
        if (!StringUtils.isEmpty((CharSequence)this.randomScoreField)) {
            randomScore.put("field", this.randomScoreField);
        }
        if (!randomScore.isEmpty()) {
            props.put("random_score", JsonUtils.toJson(randomScore));
        }
        return props;
    }

    public String getFilter() {
        return this.filter;
    }

    public Float getWeight() {
        return this.weight;
    }

    public Long getRandomScoreSeed() {
        return this.randomScoreSeed;
    }

    public String getRandomScoreField() {
        return this.randomScoreField;
    }

    public static BoostRankerBuilder builder() {
        return new BoostRankerBuilder();
    }

    public static class BoostRankerBuilder
    extends CreateCollectionReq.Function.FunctionBuilder<BoostRankerBuilder> {
        private String filter;
        private Float weight;
        private Long randomScoreSeed;
        private String randomScoreField;

        private BoostRankerBuilder() {
        }

        public BoostRankerBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public BoostRankerBuilder weight(Float weight) {
            this.weight = weight;
            return this;
        }

        public BoostRankerBuilder randomScoreSeed(Long randomScoreSeed) {
            this.randomScoreSeed = randomScoreSeed;
            return this;
        }

        public BoostRankerBuilder randomScoreField(String randomScoreField) {
            this.randomScoreField = randomScoreField;
            return this;
        }

        @Override
        public BoostRanker build() {
            return new BoostRanker(this);
        }
    }
}

