/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request;

import com.google.common.collect.Lists;
import io.milvus.v2.common.ConsistencyLevel;
import java.util.List;

public class QueryIteratorReq {
    private String databaseName;
    private String collectionName;
    private List<String> partitionNames;
    private List<String> outputFields;
    private String expr;
    private ConsistencyLevel consistencyLevel;
    private long offset;
    private long limit;
    private boolean ignoreGrowing;
    private long batchSize;
    private boolean reduceStopForBest;

    private QueryIteratorReq(QueryIteratorReqBuilder builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.outputFields = builder.outputFields;
        this.expr = builder.expr;
        this.consistencyLevel = builder.consistencyLevel;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.ignoreGrowing = builder.ignoreGrowing;
        this.batchSize = builder.batchSize;
        this.reduceStopForBest = builder.reduceStopForBest;
    }

    public static QueryIteratorReqBuilder builder() {
        return new QueryIteratorReqBuilder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    public List<String> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<String> outputFields) {
        this.outputFields = outputFields;
    }

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public boolean isIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public void setIgnoreGrowing(boolean ignoreGrowing) {
        this.ignoreGrowing = ignoreGrowing;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isReduceStopForBest() {
        return this.reduceStopForBest;
    }

    public void setReduceStopForBest(boolean reduceStopForBest) {
        this.reduceStopForBest = reduceStopForBest;
    }

    public String toString() {
        return "QueryIteratorReq{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", partitionNames=" + this.partitionNames + ", outputFields=" + this.outputFields + ", expr='" + this.expr + '\'' + ", consistencyLevel=" + (Object)((Object)this.consistencyLevel) + ", offset=" + this.offset + ", limit=" + this.limit + ", ignoreGrowing=" + this.ignoreGrowing + ", batchSize=" + this.batchSize + ", reduceStopForBest=" + this.reduceStopForBest + '}';
    }

    public static class QueryIteratorReqBuilder {
        private String databaseName;
        private String collectionName;
        private List<String> partitionNames = Lists.newArrayList();
        private List<String> outputFields = Lists.newArrayList();
        private String expr = "";
        private ConsistencyLevel consistencyLevel = null;
        private long offset = 0L;
        private long limit = -1L;
        private boolean ignoreGrowing = false;
        private long batchSize = 1000L;
        private boolean reduceStopForBest = false;

        public QueryIteratorReqBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public QueryIteratorReqBuilder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public QueryIteratorReqBuilder partitionNames(List<String> partitionNames) {
            this.partitionNames = partitionNames;
            return this;
        }

        public QueryIteratorReqBuilder outputFields(List<String> outputFields) {
            this.outputFields = outputFields;
            return this;
        }

        public QueryIteratorReqBuilder expr(String expr) {
            this.expr = expr;
            return this;
        }

        public QueryIteratorReqBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public QueryIteratorReqBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public QueryIteratorReqBuilder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public QueryIteratorReqBuilder ignoreGrowing(boolean ignoreGrowing) {
            this.ignoreGrowing = ignoreGrowing;
            return this;
        }

        public QueryIteratorReqBuilder batchSize(long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public QueryIteratorReqBuilder reduceStopForBest(boolean reduceStopForBest) {
            this.reduceStopForBest = reduceStopForBest;
            return this;
        }

        public QueryIteratorReq build() {
            return new QueryIteratorReq(this);
        }
    }
}

