/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector.request;

import io.milvus.v2.common.ConsistencyLevel;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.vector.request.AnnSearchReq;
import io.milvus.v2.service.vector.request.FunctionScore;
import java.util.List;

public class HybridSearchReq {
    private String databaseName;
    private String collectionName;
    private List<String> partitionNames;
    private List<AnnSearchReq> searchRequests;
    @Deprecated
    private int topK;
    private long limit;
    private List<String> outFields;
    private long offset;
    private int roundDecimal;
    private ConsistencyLevel consistencyLevel;
    private String groupByFieldName;
    private Integer groupSize;
    private Boolean strictGroupSize;
    @Deprecated
    private CreateCollectionReq.Function ranker;
    private FunctionScore functionScore;

    private HybridSearchReq(HybridSearchReqBuilder builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.searchRequests = builder.searchRequests;
        this.ranker = builder.ranker;
        this.functionScore = builder.functionScore;
        this.topK = builder.topK;
        this.limit = builder.limit;
        this.outFields = builder.outFields;
        this.offset = builder.offset;
        this.roundDecimal = builder.roundDecimal;
        this.consistencyLevel = builder.consistencyLevel;
        this.groupByFieldName = builder.groupByFieldName;
        this.groupSize = builder.groupSize;
        this.strictGroupSize = builder.strictGroupSize;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    public List<AnnSearchReq> getSearchRequests() {
        return this.searchRequests;
    }

    public void setSearchRequests(List<AnnSearchReq> searchRequests) {
        this.searchRequests = searchRequests;
    }

    public CreateCollectionReq.Function getRanker() {
        return this.ranker;
    }

    public void setRanker(CreateCollectionReq.Function ranker) {
        this.ranker = ranker;
    }

    public FunctionScore getFunctionScore() {
        return this.functionScore;
    }

    public void setFunctionScore(FunctionScore functionScore) {
        this.functionScore = functionScore;
    }

    @Deprecated
    public int getTopK() {
        return this.topK;
    }

    @Deprecated
    public void setTopK(int topK) {
        this.topK = topK;
        this.limit = topK;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
        this.topK = (int)limit;
    }

    public List<String> getOutFields() {
        return this.outFields;
    }

    public void setOutFields(List<String> outFields) {
        this.outFields = outFields;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int getRoundDecimal() {
        return this.roundDecimal;
    }

    public void setRoundDecimal(int roundDecimal) {
        this.roundDecimal = roundDecimal;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public String getGroupByFieldName() {
        return this.groupByFieldName;
    }

    public void setGroupByFieldName(String groupByFieldName) {
        this.groupByFieldName = groupByFieldName;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(Integer groupSize) {
        this.groupSize = groupSize;
    }

    public Boolean getStrictGroupSize() {
        return this.strictGroupSize;
    }

    public void setStrictGroupSize(Boolean strictGroupSize) {
        this.strictGroupSize = strictGroupSize;
    }

    public String toString() {
        return "HybridSearchReq{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", partitionNames=" + this.partitionNames + ", searchRequests=" + this.searchRequests + ", ranker=" + this.ranker + ", functionScore=" + this.functionScore + ", topK=" + this.topK + ", limit=" + this.limit + ", outFields=" + this.outFields + ", offset=" + this.offset + ", roundDecimal=" + this.roundDecimal + ", consistencyLevel=" + (Object)((Object)this.consistencyLevel) + ", groupByFieldName='" + this.groupByFieldName + '\'' + ", groupSize=" + this.groupSize + ", strictGroupSize=" + this.strictGroupSize + '}';
    }

    public static HybridSearchReqBuilder builder() {
        return new HybridSearchReqBuilder();
    }

    public static class HybridSearchReqBuilder {
        private String databaseName;
        private String collectionName;
        private List<String> partitionNames;
        private List<AnnSearchReq> searchRequests;
        private CreateCollectionReq.Function ranker;
        private FunctionScore functionScore;
        private int topK = 0;
        private long limit = 0L;
        private List<String> outFields;
        private long offset;
        private int roundDecimal = -1;
        private ConsistencyLevel consistencyLevel = null;
        private String groupByFieldName;
        private Integer groupSize;
        private Boolean strictGroupSize;

        private HybridSearchReqBuilder() {
        }

        public HybridSearchReqBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public HybridSearchReqBuilder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public HybridSearchReqBuilder partitionNames(List<String> partitionNames) {
            this.partitionNames = partitionNames;
            return this;
        }

        public HybridSearchReqBuilder searchRequests(List<AnnSearchReq> searchRequests) {
            this.searchRequests = searchRequests;
            return this;
        }

        public HybridSearchReqBuilder ranker(CreateCollectionReq.Function ranker) {
            this.ranker = ranker;
            return this;
        }

        public HybridSearchReqBuilder functionScore(FunctionScore functionScore) {
            this.functionScore = functionScore;
            return this;
        }

        @Deprecated
        public HybridSearchReqBuilder topK(int topK) {
            this.topK = topK;
            this.limit = topK;
            return this;
        }

        public HybridSearchReqBuilder limit(long limit) {
            this.topK = (int)limit;
            this.limit = limit;
            return this;
        }

        public HybridSearchReqBuilder outFields(List<String> outFields) {
            this.outFields = outFields;
            return this;
        }

        public HybridSearchReqBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public HybridSearchReqBuilder roundDecimal(int roundDecimal) {
            this.roundDecimal = roundDecimal;
            return this;
        }

        public HybridSearchReqBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public HybridSearchReqBuilder groupByFieldName(String groupByFieldName) {
            this.groupByFieldName = groupByFieldName;
            return this;
        }

        public HybridSearchReqBuilder groupSize(Integer groupSize) {
            this.groupSize = groupSize;
            return this;
        }

        public HybridSearchReqBuilder strictGroupSize(Boolean strictGroupSize) {
            this.strictGroupSize = strictGroupSize;
            return this;
        }

        public HybridSearchReq build() {
            return new HybridSearchReq(this);
        }
    }
}

