/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.vector;

import com.google.protobuf.ByteString;
import io.milvus.common.utils.GTsDict;
import io.milvus.common.utils.JsonUtils;
import io.milvus.grpc.AnalyzerResult;
import io.milvus.grpc.AnalyzerToken;
import io.milvus.grpc.DeleteRequest;
import io.milvus.grpc.DescribeCollectionRequest;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.ErrorCode;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.HybridSearchRequest;
import io.milvus.grpc.InsertRequest;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.RunAnalyzerRequest;
import io.milvus.grpc.RunAnalyzerResponse;
import io.milvus.grpc.SearchRequest;
import io.milvus.grpc.SearchResults;
import io.milvus.grpc.Status;
import io.milvus.grpc.UpsertRequest;
import io.milvus.orm.iterator.QueryIterator;
import io.milvus.orm.iterator.SearchIterator;
import io.milvus.orm.iterator.SearchIteratorV2;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import io.milvus.v2.service.collection.response.DescribeCollectionResp;
import io.milvus.v2.service.vector.request.DeleteReq;
import io.milvus.v2.service.vector.request.GetReq;
import io.milvus.v2.service.vector.request.HybridSearchReq;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.QueryIteratorReq;
import io.milvus.v2.service.vector.request.QueryReq;
import io.milvus.v2.service.vector.request.RunAnalyzerReq;
import io.milvus.v2.service.vector.request.SearchIteratorReq;
import io.milvus.v2.service.vector.request.SearchIteratorReqV2;
import io.milvus.v2.service.vector.request.SearchReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import io.milvus.v2.service.vector.response.DeleteResp;
import io.milvus.v2.service.vector.response.GetResp;
import io.milvus.v2.service.vector.response.InsertResp;
import io.milvus.v2.service.vector.response.QueryResp;
import io.milvus.v2.service.vector.response.RunAnalyzerResp;
import io.milvus.v2.service.vector.response.SearchResp;
import io.milvus.v2.service.vector.response.UpsertResp;
import io.milvus.v2.utils.DataUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorService
extends BaseService {
    Logger logger = LoggerFactory.getLogger(VectorService.class);
    private ConcurrentHashMap<String, DescribeCollectionResponse> cacheCollectionInfo = new ConcurrentHashMap();

    private DescribeCollectionResponse describeCollection(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String dbName, String collectionName) {
        String title = String.format("Describe collection '%s' in database: '%s'", collectionName, dbName);
        DescribeCollectionRequest.Builder builder = DescribeCollectionRequest.newBuilder().setCollectionName(collectionName);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        DescribeCollectionResponse response = blockingStub.describeCollection(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        return response;
    }

    private DescribeCollectionResponse getCollectionInfo(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, String databaseName, String collectionName, boolean forceUpdate) {
        String key = GTsDict.CombineCollectionName(this.actualDbName(databaseName), collectionName);
        DescribeCollectionResponse info = this.cacheCollectionInfo.get(key);
        if (info == null || forceUpdate) {
            info = this.describeCollection(blockingStub, databaseName, collectionName);
            this.cacheCollectionInfo.put(key, info);
        }
        return info;
    }

    public void cleanCollectionCache() {
        this.cacheCollectionInfo.clear();
    }

    private void cleanCacheIfFailed(Status status, String databaseName, String collectionName) {
        if (status.getCode() != 0 && status.getCode() != 8 || !status.getErrorCode().equals((Object)ErrorCode.Success) && status.getErrorCode() != ErrorCode.RateLimit) {
            this.removeCollectionCache(databaseName, collectionName);
        }
    }

    public void removeCollectionCache(String databaseName, String collectionName) {
        String key = GTsDict.CombineCollectionName(this.actualDbName(databaseName), collectionName);
        this.cacheCollectionInfo.remove(key);
    }

    private InsertRequest buildInsertRequest(InsertReq request, DescribeCollectionResponse descResp) {
        DataUtils.InsertBuilderWrapper requestBuilder = new DataUtils.InsertBuilderWrapper();
        DescribeCollectionResp descColl = this.convertUtils.convertDescCollectionResp(descResp);
        InsertRequest rpcRequest = requestBuilder.convertGrpcInsertRequest(request, descColl);
        return rpcRequest.toBuilder().setSchemaTimestamp(descResp.getUpdateTimestamp()).build();
    }

    public InsertResp insert(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, InsertReq request) {
        InsertRequest rpcRequest;
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("Insert to collection: '%s' in database: '%s'", collectionName, dbName);
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, false);
        try {
            rpcRequest = this.buildInsertRequest(request, descResp);
        }
        catch (Exception ignored) {
            descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, true);
            rpcRequest = this.buildInsertRequest(request, descResp);
        }
        MutationResult response = blockingStub.insert(rpcRequest);
        if (response.getStatus().getErrorCode() == ErrorCode.SchemaMismatch) {
            this.getCollectionInfo(blockingStub, dbName, collectionName, true);
            return this.insert(blockingStub, request);
        }
        this.cleanCacheIfFailed(response.getStatus(), dbName, collectionName);
        this.rpcUtils.handleResponse(title, response.getStatus());
        String key = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
        GTsDict.getInstance().updateCollectionTs(key, response.getTimestamp());
        ArrayList<Object> ids = new ArrayList();
        if (response.getIDs().hasIntId()) {
            ids = new ArrayList<Long>(response.getIDs().getIntId().getDataList());
        } else if (response.getIDs().hasStrId()) {
            ids = new ArrayList(response.getIDs().getStrId().getDataList());
        }
        return InsertResp.builder().InsertCnt(response.getInsertCnt()).primaryKeys(ids).build();
    }

    private UpsertRequest buildUpsertRequest(UpsertReq request, DescribeCollectionResponse descResp) {
        DataUtils.InsertBuilderWrapper requestBuilder = new DataUtils.InsertBuilderWrapper();
        DescribeCollectionResp descColl = this.convertUtils.convertDescCollectionResp(descResp);
        UpsertRequest rpcRequest = requestBuilder.convertGrpcUpsertRequest(request, descColl);
        return rpcRequest.toBuilder().setSchemaTimestamp(descResp.getUpdateTimestamp()).build();
    }

    public UpsertResp upsert(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, UpsertReq request) {
        UpsertRequest rpcRequest;
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("Upsert to collection: '%s' in database: '%s'", collectionName, dbName);
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, false);
        try {
            rpcRequest = this.buildUpsertRequest(request, descResp);
        }
        catch (Exception ignored) {
            descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, true);
            rpcRequest = this.buildUpsertRequest(request, descResp);
        }
        MutationResult response = blockingStub.upsert(rpcRequest);
        if (response.getStatus().getErrorCode() == ErrorCode.SchemaMismatch) {
            this.getCollectionInfo(blockingStub, dbName, collectionName, true);
            return this.upsert(blockingStub, request);
        }
        this.cleanCacheIfFailed(response.getStatus(), dbName, collectionName);
        this.rpcUtils.handleResponse(title, response.getStatus());
        String key = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
        GTsDict.getInstance().updateCollectionTs(key, response.getTimestamp());
        ArrayList<Object> ids = new ArrayList();
        if (response.getIDs().hasIntId()) {
            ids = new ArrayList<Long>(response.getIDs().getIntId().getDataList());
        } else if (response.getIDs().hasStrId()) {
            ids = new ArrayList(response.getIDs().getStrId().getDataList());
        }
        return UpsertResp.builder().upsertCnt(response.getUpsertCnt()).primaryKeys(ids).build();
    }

    public QueryResp query(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, QueryReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("Query collection: '%s' in database: '%s'", collectionName, dbName);
        if (StringUtils.isNotEmpty((CharSequence)request.getFilter()) && CollectionUtils.isNotEmpty(request.getIds())) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.INVALID_PARAMS, "filter and ids can't be set at the same time");
        }
        if (CollectionUtils.isNotEmpty(request.getIds())) {
            DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, false);
            String primaryKeyName = "";
            List<FieldSchema> fields = descResp.getSchema().getFieldsList();
            for (FieldSchema field : fields) {
                if (!field.getIsPrimaryKey()) continue;
                primaryKeyName = field.getName();
                break;
            }
            if (StringUtils.isEmpty((CharSequence)primaryKeyName)) {
                throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.SERVER_ERROR, "cannot find the primary key field in collection schema");
            }
            request.setFilter(this.vectorUtils.getExprById(primaryKeyName, request.getIds()));
        }
        request.setDatabaseName(this.actualDbName(request.getDatabaseName()));
        QueryResults response = blockingStub.query(this.vectorUtils.ConvertToGrpcQueryRequest(request));
        this.rpcUtils.handleResponse(title, response.getStatus());
        return QueryResp.builder().queryResults(this.convertUtils.getEntities(response)).sessionTs(response.getSessionTs()).build();
    }

    public SearchResp search(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, SearchReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("Search collection: '%s' in database: '%s'", collectionName, dbName);
        request.setDatabaseName(this.actualDbName(dbName));
        SearchRequest searchRequest = this.vectorUtils.ConvertToGrpcSearchRequest(request);
        SearchResults response = blockingStub.search(searchRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return SearchResp.builder().searchResults(this.convertUtils.getEntities(response)).sessionTs(response.getSessionTs()).recalls(response.getResults().getRecallsList()).build();
    }

    public SearchResp hybridSearch(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, HybridSearchReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("Hybrid search collection: '%s' in database: '%s'", collectionName, dbName);
        request.setDatabaseName(this.actualDbName(dbName));
        HybridSearchRequest searchRequest = this.vectorUtils.ConvertToGrpcHybridSearchRequest(request);
        SearchResults response = blockingStub.hybridSearch(searchRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return SearchResp.builder().searchResults(this.convertUtils.getEntities(response)).recalls(response.getResults().getRecallsList()).build();
    }

    public QueryIterator queryIterator(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, QueryIteratorReq request) {
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, request.getDatabaseName(), request.getCollectionName(), false);
        DescribeCollectionResp respR = this.convertUtils.convertDescCollectionResp(descResp);
        CreateCollectionReq.FieldSchema pkField = respR.getCollectionSchema().getField(respR.getPrimaryFieldName());
        return new QueryIterator(request, blockingStub, pkField);
    }

    public SearchIterator searchIterator(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, SearchIteratorReq request) {
        DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, request.getDatabaseName(), request.getCollectionName(), false);
        DescribeCollectionResp respR = this.convertUtils.convertDescCollectionResp(descResp);
        CreateCollectionReq.FieldSchema pkField = respR.getCollectionSchema().getField(respR.getPrimaryFieldName());
        return new SearchIterator(request, blockingStub, pkField);
    }

    public SearchIteratorV2 searchIteratorV2(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, SearchIteratorReqV2 request) {
        return new SearchIteratorV2(request, blockingStub);
    }

    public DeleteResp delete(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DeleteReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("Delete entities of collection: '%s' in database: '%s'", collectionName, dbName);
        if (request.getFilter() != null && request.getIds() != null) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.INVALID_PARAMS, "filter and ids can't be set at the same time");
        }
        if (request.getFilter() == null) {
            DescribeCollectionResponse descResp = this.getCollectionInfo(blockingStub, dbName, collectionName, false);
            DescribeCollectionResp respR = this.convertUtils.convertDescCollectionResp(descResp);
            request.setFilter(this.vectorUtils.getExprById(respR.getPrimaryFieldName(), request.getIds()));
        }
        DeleteRequest rpcRequest = this.dataUtils.ConvertToGrpcDeleteRequest(request);
        MutationResult response = blockingStub.delete(rpcRequest);
        this.cleanCacheIfFailed(response.getStatus(), dbName, collectionName);
        this.rpcUtils.handleResponse(title, response.getStatus());
        String key = GTsDict.CombineCollectionName(this.actualDbName(dbName), collectionName);
        GTsDict.getInstance().updateCollectionTs(key, response.getTimestamp());
        return DeleteResp.builder().deleteCnt(response.getDeleteCnt()).build();
    }

    public GetResp get(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("Get entities of collection: '%s' in database: '%s'", collectionName, dbName);
        this.logger.debug(title);
        QueryReq queryReq = QueryReq.builder().databaseName(dbName).collectionName(collectionName).ids(request.getIds()).build();
        if (request.getOutputFields() != null) {
            queryReq.setOutputFields(request.getOutputFields());
        }
        QueryResp queryResp = this.query(blockingStub, queryReq);
        return GetResp.builder().getResults(queryResp.getQueryResults()).build();
    }

    public RunAnalyzerResp runAnalyzer(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, RunAnalyzerReq request) {
        String title = "RunAnalyzer";
        if (request.getTexts().isEmpty()) {
            throw new MilvusClientException(io.milvus.v2.exception.ErrorCode.INVALID_PARAMS, "Texts list is empty.");
        }
        RunAnalyzerRequest.Builder builder = RunAnalyzerRequest.newBuilder();
        ArrayList<ByteString> byteStrings = new ArrayList<ByteString>();
        for (String text : request.getTexts()) {
            byteStrings.add(ByteString.copyFrom((byte[])text.getBytes()));
        }
        List<String> analyzerNames = request.getAnalyzerNames();
        builder.addAllAnalyzerNames(analyzerNames);
        String params = JsonUtils.toJson(request.getAnalyzerParams());
        this.logger.debug(params);
        RunAnalyzerRequest runRequest = builder.addAllPlaceholder(byteStrings).setAnalyzerParams(params).setWithDetail(request.getWithDetail()).setWithHash(request.getWithHash()).setDbName(request.getDatabaseName()).setCollectionName(request.getCollectionName()).setFieldName(request.getFieldName()).build();
        RunAnalyzerResponse response = blockingStub.runAnalyzer(runRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<RunAnalyzerResp.AnalyzerResult> toResults = new ArrayList<RunAnalyzerResp.AnalyzerResult>();
        List<AnalyzerResult> results = response.getResultsList();
        results.forEach(item -> {
            ArrayList<RunAnalyzerResp.AnalyzerToken> toTokens = new ArrayList<RunAnalyzerResp.AnalyzerToken>();
            List<AnalyzerToken> tokens = item.getTokensList();
            tokens.forEach(token -> toTokens.add(RunAnalyzerResp.AnalyzerToken.builder().token(token.getToken()).startOffset(token.getStartOffset()).endOffset(token.getEndOffset()).position(token.getPosition()).positionLength(token.getPositionLength()).hash((long)token.getHash() & 0xFFFFFFFFL).build()));
            toResults.add(RunAnalyzerResp.AnalyzerResult.builder().tokens(toTokens).build());
        });
        return RunAnalyzerResp.builder().results(toResults).build();
    }
}

