/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.utility;

import io.milvus.grpc.AlterAliasRequest;
import io.milvus.grpc.CheckHealthRequest;
import io.milvus.grpc.CheckHealthResponse;
import io.milvus.grpc.CreateAliasRequest;
import io.milvus.grpc.DescribeAliasRequest;
import io.milvus.grpc.DescribeAliasResponse;
import io.milvus.grpc.DescribeCollectionRequest;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.DropAliasRequest;
import io.milvus.grpc.FlushRequest;
import io.milvus.grpc.FlushResponse;
import io.milvus.grpc.GetCompactionStateRequest;
import io.milvus.grpc.GetCompactionStateResponse;
import io.milvus.grpc.GetFlushStateRequest;
import io.milvus.grpc.GetFlushStateResponse;
import io.milvus.grpc.GetPersistentSegmentInfoRequest;
import io.milvus.grpc.GetPersistentSegmentInfoResponse;
import io.milvus.grpc.GetQuerySegmentInfoRequest;
import io.milvus.grpc.GetQuerySegmentInfoResponse;
import io.milvus.grpc.ListAliasesRequest;
import io.milvus.grpc.ListAliasesResponse;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.ManualCompactionRequest;
import io.milvus.grpc.ManualCompactionResponse;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.grpc.Status;
import io.milvus.v2.common.CompactionState;
import io.milvus.v2.exception.ErrorCode;
import io.milvus.v2.exception.MilvusClientException;
import io.milvus.v2.service.BaseService;
import io.milvus.v2.service.utility.request.AlterAliasReq;
import io.milvus.v2.service.utility.request.CompactReq;
import io.milvus.v2.service.utility.request.CreateAliasReq;
import io.milvus.v2.service.utility.request.DescribeAliasReq;
import io.milvus.v2.service.utility.request.DropAliasReq;
import io.milvus.v2.service.utility.request.FlushReq;
import io.milvus.v2.service.utility.request.GetCompactionStateReq;
import io.milvus.v2.service.utility.request.GetPersistentSegmentInfoReq;
import io.milvus.v2.service.utility.request.GetQuerySegmentInfoReq;
import io.milvus.v2.service.utility.request.ListAliasesReq;
import io.milvus.v2.service.utility.response.CheckHealthResp;
import io.milvus.v2.service.utility.response.CompactResp;
import io.milvus.v2.service.utility.response.DescribeAliasResp;
import io.milvus.v2.service.utility.response.FlushResp;
import io.milvus.v2.service.utility.response.GetCompactionStateResp;
import io.milvus.v2.service.utility.response.GetPersistentSegmentInfoResp;
import io.milvus.v2.service.utility.response.GetQuerySegmentInfoResp;
import io.milvus.v2.service.utility.response.ListAliasResp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class UtilityService
extends BaseService {
    public FlushResp flush(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, FlushReq request) {
        String dbName = request.getDatabaseName();
        List<String> collectionNames = request.getCollectionNames();
        String title = String.format("Flush collections: '%s' in database: '%s'", collectionNames, dbName);
        if (collectionNames.isEmpty()) {
            throw new MilvusClientException(ErrorCode.INVALID_PARAMS, "Collection name list can not be null or empty");
        }
        FlushRequest.Builder builder = FlushRequest.newBuilder().addAllCollectionNames(collectionNames);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        FlushResponse response = blockingStub.flush(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        Map<String, LongArray> rpcCollSegIDs = response.getCollSegIDsMap();
        HashMap<String, List<Long>> collectionSegmentIDs = new HashMap<String, List<Long>>();
        rpcCollSegIDs.forEach((key, value) -> collectionSegmentIDs.put((String)key, value.getDataList()));
        Map<String, Long> collectionFlushTs = response.getCollFlushTsMap();
        return FlushResp.builder().databaseName(response.getDbName()).collectionSegmentIDs(collectionSegmentIDs).collectionFlushTs(collectionFlushTs).build();
    }

    public Void waitFlush(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, FlushResp flushResp) {
        Map<String, List<Long>> collectionSegmentIDs = flushResp.getCollectionSegmentIDs();
        Map<String, Long> collectionFlushTs = flushResp.getCollectionFlushTs();
        collectionSegmentIDs.forEach((collectionName, segmentIDs) -> {
            if (collectionFlushTs.containsKey(collectionName)) {
                Long flushTs = (Long)collectionFlushTs.get(collectionName);
                boolean flushed = false;
                while (!flushed) {
                    GetFlushStateResponse flushResponse = blockingStub.getFlushState(GetFlushStateRequest.newBuilder().setDbName(flushResp.getDatabaseName()).addAllSegmentIDs((Iterable<? extends Long>)segmentIDs).setFlushTs(flushTs).build());
                    flushed = flushResponse.getFlushed();
                }
            }
        });
        return null;
    }

    public CompactResp compact(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CompactReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("Compact collection: '%s' in database: '%s'", collectionName, dbName);
        DescribeCollectionRequest.Builder descBuilder = DescribeCollectionRequest.newBuilder().setCollectionName(request.getCollectionName());
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            descBuilder.setDbName(dbName);
        }
        DescribeCollectionResponse descResponse = blockingStub.describeCollection(descBuilder.build());
        this.rpcUtils.handleResponse(title, descResponse.getStatus());
        ManualCompactionRequest.Builder builder = ManualCompactionRequest.newBuilder().setCollectionID(descResponse.getCollectionID()).setMajorCompaction(request.getIsClustering());
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        ManualCompactionResponse response = blockingStub.manualCompaction(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        return CompactResp.builder().compactionID(response.getCompactionID()).build();
    }

    public GetCompactionStateResp getCompactionState(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetCompactionStateReq request) {
        String title = "Get compaction state";
        GetCompactionStateRequest getRequest = GetCompactionStateRequest.newBuilder().setCompactionID(request.getCompactionID()).build();
        GetCompactionStateResponse response = blockingStub.getCompactionState(getRequest);
        this.rpcUtils.handleResponse(title, response.getStatus());
        return GetCompactionStateResp.builder().state(CompactionState.valueOf(response.getState().name())).executingPlanNo(response.getExecutingPlanNo()).timeoutPlanNo(response.getTimeoutPlanNo()).completedPlanNo(response.getCompletedPlanNo()).build();
    }

    public Void createAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, CreateAliasReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String alias = request.getAlias();
        String title = String.format("Create alias '%s' of collection: '%s' in database: '%s' ", alias, collectionName, dbName);
        CreateAliasRequest.Builder createAliasRequestBuilder = CreateAliasRequest.newBuilder().setCollectionName(collectionName).setAlias(alias);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            createAliasRequestBuilder.setDbName(dbName);
        }
        Status status = blockingStub.createAlias(createAliasRequestBuilder.build());
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void dropAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DropAliasReq request) {
        String dbName = request.getDatabaseName();
        String alias = request.getAlias();
        String title = String.format("Drop aliases '%s' in database: '%s'", alias, dbName);
        DropAliasRequest.Builder dropAliasRequestBuilder = DropAliasRequest.newBuilder().setAlias(alias);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            dropAliasRequestBuilder.setDbName(dbName);
        }
        Status status = blockingStub.dropAlias(dropAliasRequestBuilder.build());
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public Void alterAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, AlterAliasReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String alias = request.getAlias();
        String title = String.format("Alter alias '%s' of collection: '%s' in database: '%s'", alias, collectionName, dbName);
        AlterAliasRequest.Builder alterAliasRequestBuilder = AlterAliasRequest.newBuilder().setCollectionName(collectionName).setAlias(alias);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            alterAliasRequestBuilder.setDbName(dbName);
        }
        Status status = blockingStub.alterAlias(alterAliasRequestBuilder.build());
        this.rpcUtils.handleResponse(title, status);
        return null;
    }

    public DescribeAliasResp describeAlias(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, DescribeAliasReq request) {
        String dbName = request.getDatabaseName();
        String alias = request.getAlias();
        String title = String.format("Describe alias '%s' in database: '%s'", alias, dbName);
        DescribeAliasRequest.Builder builder = DescribeAliasRequest.newBuilder().setAlias(alias);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        DescribeAliasResponse response = blockingStub.describeAlias(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        return DescribeAliasResp.builder().databaseName(response.getDbName()).collectionName(response.getCollection()).alias(response.getAlias()).build();
    }

    public ListAliasResp listAliases(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, ListAliasesReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("List alias of collection: '%s' in database: '%s'", collectionName, dbName);
        ListAliasesRequest.Builder builder = ListAliasesRequest.newBuilder().setCollectionName(collectionName);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        ListAliasesResponse response = blockingStub.listAliases(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        return ListAliasResp.builder().collectionName(response.getCollectionName()).alias((List<String>)response.getAliasesList()).build();
    }

    public CheckHealthResp checkHealth(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub) {
        String title = "Check health";
        CheckHealthResponse response = blockingStub.checkHealth(CheckHealthRequest.newBuilder().build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<String> states = new ArrayList<String>();
        response.getQuotaStatesList().forEach(s -> states.add(s.name()));
        return CheckHealthResp.builder().isHealthy(response.getIsHealthy()).reasons(response.getReasonsList().stream().collect(Collectors.toList())).quotaStates(states).build();
    }

    public GetPersistentSegmentInfoResp getPersistentSegmentInfo(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetPersistentSegmentInfoReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("Get persistent segment info in collection: '%s' in database: '%s'", collectionName, dbName);
        GetPersistentSegmentInfoRequest.Builder builder = GetPersistentSegmentInfoRequest.newBuilder().setCollectionName(collectionName);
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        GetPersistentSegmentInfoResponse response = blockingStub.getPersistentSegmentInfo(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<GetPersistentSegmentInfoResp.PersistentSegmentInfo> segmentInfos = new ArrayList<GetPersistentSegmentInfoResp.PersistentSegmentInfo>();
        response.getInfosList().forEach(info -> segmentInfos.add(GetPersistentSegmentInfoResp.PersistentSegmentInfo.builder().segmentID(info.getSegmentID()).collectionID(info.getCollectionID()).partitionID(info.getPartitionID()).numOfRows(info.getNumRows()).state(info.getState().name()).level(info.getLevel().name()).isSorted(info.getIsSorted()).build()));
        return GetPersistentSegmentInfoResp.builder().segmentInfos(segmentInfos).build();
    }

    public GetQuerySegmentInfoResp getQuerySegmentInfo(MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub, GetQuerySegmentInfoReq request) {
        String dbName = request.getDatabaseName();
        String collectionName = request.getCollectionName();
        String title = String.format("Get query segment info in collection: '%s' in database: '%s'", collectionName, dbName);
        GetQuerySegmentInfoRequest.Builder builder = GetQuerySegmentInfoRequest.newBuilder().setCollectionName(request.getCollectionName());
        if (StringUtils.isNotEmpty((CharSequence)dbName)) {
            builder.setDbName(dbName);
        }
        GetQuerySegmentInfoResponse response = blockingStub.getQuerySegmentInfo(builder.build());
        this.rpcUtils.handleResponse(title, response.getStatus());
        ArrayList<GetQuerySegmentInfoResp.QuerySegmentInfo> segmentInfos = new ArrayList<GetQuerySegmentInfoResp.QuerySegmentInfo>();
        response.getInfosList().forEach(info -> segmentInfos.add(GetQuerySegmentInfoResp.QuerySegmentInfo.builder().segmentID(info.getSegmentID()).collectionID(info.getCollectionID()).partitionID(info.getPartitionID()).memSize(info.getMemSize()).numOfRows(info.getNumRows()).indexName(info.getIndexName()).indexID(info.getIndexID()).state(info.getState().name()).level(info.getLevel().name()).nodeIDs(info.getNodeIdsList()).isSorted(info.getIsSorted()).build()));
        return GetQuerySegmentInfoResp.builder().segmentInfos(segmentInfos).build();
    }
}

