/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.service.collection.request;

import java.util.ArrayList;
import java.util.List;

public class LoadCollectionReq {
    private String databaseName;
    private String collectionName;
    private Integer numReplicas = 1;
    @Deprecated
    private Boolean async = Boolean.FALSE;
    private Boolean sync = Boolean.TRUE;
    private Long timeout = 60000L;
    private Boolean refresh = Boolean.FALSE;
    private List<String> loadFields = new ArrayList<String>();
    private Boolean skipLoadDynamicField = Boolean.FALSE;
    private List<String> resourceGroups = new ArrayList<String>();

    private LoadCollectionReq(LoadCollectionReqBuilder builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.numReplicas = builder.numReplicas;
        this.async = builder.async;
        this.sync = builder.sync;
        this.timeout = builder.timeout;
        this.refresh = builder.refresh;
        this.loadFields = builder.loadFields;
        this.skipLoadDynamicField = builder.skipLoadDynamicField;
        this.resourceGroups = builder.resourceGroups;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public Integer getNumReplicas() {
        return this.numReplicas;
    }

    public void setNumReplicas(Integer numReplicas) {
        this.numReplicas = numReplicas;
    }

    @Deprecated
    public Boolean getAsync() {
        return this.async;
    }

    @Deprecated
    public void setAsync(Boolean async) {
        this.async = async;
        this.sync = async == false;
    }

    public Boolean getSync() {
        return this.sync;
    }

    public void setSync(Boolean sync) {
        this.sync = sync;
        this.async = sync == false;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public Boolean getRefresh() {
        return this.refresh;
    }

    public void setRefresh(Boolean refresh) {
        this.refresh = refresh;
    }

    public List<String> getLoadFields() {
        return this.loadFields;
    }

    public void setLoadFields(List<String> loadFields) {
        this.loadFields = loadFields;
    }

    public Boolean getSkipLoadDynamicField() {
        return this.skipLoadDynamicField;
    }

    public void setSkipLoadDynamicField(Boolean skipLoadDynamicField) {
        this.skipLoadDynamicField = skipLoadDynamicField;
    }

    public List<String> getResourceGroups() {
        return this.resourceGroups;
    }

    public void setResourceGroups(List<String> resourceGroups) {
        this.resourceGroups = resourceGroups;
    }

    public String toString() {
        return "LoadCollectionReq{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", numReplicas=" + this.numReplicas + ", async=" + this.async + ", sync=" + this.sync + ", timeout=" + this.timeout + ", refresh=" + this.refresh + ", loadFields=" + this.loadFields + ", skipLoadDynamicField=" + this.skipLoadDynamicField + ", resourceGroups=" + this.resourceGroups + '}';
    }

    public static LoadCollectionReqBuilder builder() {
        return new LoadCollectionReqBuilder();
    }

    public static class LoadCollectionReqBuilder {
        private String databaseName;
        private String collectionName;
        private Integer numReplicas = 1;
        private Boolean async = Boolean.FALSE;
        private Boolean sync = Boolean.TRUE;
        private Long timeout = 60000L;
        private Boolean refresh = Boolean.FALSE;
        private List<String> loadFields = new ArrayList<String>();
        private Boolean skipLoadDynamicField = Boolean.FALSE;
        private List<String> resourceGroups = new ArrayList<String>();

        private LoadCollectionReqBuilder() {
        }

        public LoadCollectionReqBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public LoadCollectionReqBuilder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public LoadCollectionReqBuilder numReplicas(Integer numReplicas) {
            this.numReplicas = numReplicas;
            return this;
        }

        @Deprecated
        public LoadCollectionReqBuilder async(Boolean async) {
            this.async = async;
            this.sync = async == false;
            return this;
        }

        public LoadCollectionReqBuilder sync(Boolean sync) {
            this.sync = sync;
            this.async = sync == false;
            return this;
        }

        public LoadCollectionReqBuilder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public LoadCollectionReqBuilder refresh(Boolean refresh) {
            this.refresh = refresh;
            return this;
        }

        public LoadCollectionReqBuilder loadFields(List<String> loadFields) {
            this.loadFields = loadFields;
            return this;
        }

        public LoadCollectionReqBuilder skipLoadDynamicField(Boolean skipLoadDynamicField) {
            this.skipLoadDynamicField = skipLoadDynamicField;
            return this;
        }

        public LoadCollectionReqBuilder resourceGroups(List<String> resourceGroups) {
            this.resourceGroups = resourceGroups;
            return this;
        }

        public LoadCollectionReq build() {
            return new LoadCollectionReq(this);
        }
    }
}

