/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.client;

public class RetryConfig {
    private int maxRetryTimes = 75;
    private long initialBackOffMs = 10L;
    private long maxBackOffMs = 3000L;
    private int backOffMultiplier = 3;
    private boolean retryOnRateLimit = true;
    private long maxRetryTimeoutMs = 0L;

    private RetryConfig(RetryConfigBuilder builder) {
        this.maxRetryTimes = builder.maxRetryTimes;
        this.initialBackOffMs = builder.initialBackOffMs;
        this.maxBackOffMs = builder.maxBackOffMs;
        this.backOffMultiplier = builder.backOffMultiplier;
        this.retryOnRateLimit = builder.retryOnRateLimit;
        this.maxRetryTimeoutMs = builder.maxRetryTimeoutMs;
    }

    public static RetryConfigBuilder builder() {
        return new RetryConfigBuilder();
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public long getInitialBackOffMs() {
        return this.initialBackOffMs;
    }

    public long getMaxBackOffMs() {
        return this.maxBackOffMs;
    }

    public int getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public boolean isRetryOnRateLimit() {
        return this.retryOnRateLimit;
    }

    public long getMaxRetryTimeoutMs() {
        return this.maxRetryTimeoutMs;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public void setInitialBackOffMs(long initialBackOffMs) {
        this.initialBackOffMs = initialBackOffMs;
    }

    public void setMaxBackOffMs(long maxBackOffMs) {
        this.maxBackOffMs = maxBackOffMs;
    }

    public void setBackOffMultiplier(int backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public void setRetryOnRateLimit(boolean retryOnRateLimit) {
        this.retryOnRateLimit = retryOnRateLimit;
    }

    public void setMaxRetryTimeoutMs(long maxRetryTimeoutMs) {
        this.maxRetryTimeoutMs = maxRetryTimeoutMs;
    }

    public String toString() {
        return "RetryConfig{maxRetryTimes=" + this.maxRetryTimes + ", initialBackOffMs=" + this.initialBackOffMs + ", maxBackOffMs=" + this.maxBackOffMs + ", backOffMultiplier=" + this.backOffMultiplier + ", retryOnRateLimit=" + this.retryOnRateLimit + ", maxRetryTimeoutMs=" + this.maxRetryTimeoutMs + '}';
    }

    public static class RetryConfigBuilder {
        private int maxRetryTimes = 75;
        private long initialBackOffMs = 10L;
        private long maxBackOffMs = 3000L;
        private int backOffMultiplier = 3;
        private boolean retryOnRateLimit = true;
        private long maxRetryTimeoutMs = 0L;

        public RetryConfigBuilder maxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public RetryConfigBuilder initialBackOffMs(long initialBackOffMs) {
            this.initialBackOffMs = initialBackOffMs;
            return this;
        }

        public RetryConfigBuilder maxBackOffMs(long maxBackOffMs) {
            this.maxBackOffMs = maxBackOffMs;
            return this;
        }

        public RetryConfigBuilder backOffMultiplier(int backOffMultiplier) {
            this.backOffMultiplier = backOffMultiplier;
            return this;
        }

        public RetryConfigBuilder retryOnRateLimit(boolean retryOnRateLimit) {
            this.retryOnRateLimit = retryOnRateLimit;
            return this;
        }

        public RetryConfigBuilder maxRetryTimeoutMs(long maxRetryTimeoutMs) {
            this.maxRetryTimeoutMs = maxRetryTimeoutMs;
            return this;
        }

        public RetryConfig build() {
            return new RetryConfig(this);
        }
    }
}

