/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import io.milvus.exception.IllegalResponseException;
import io.milvus.grpc.ShowPartitionsResponse;
import java.util.ArrayList;
import java.util.List;

public class ShowPartResponseWrapper {
    private final ShowPartitionsResponse response;

    public ShowPartResponseWrapper(ShowPartitionsResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("ShowPartitionsResponse cannot be null");
        }
        this.response = response;
    }

    public List<PartitionInfo> getPartitionsInfo() throws IllegalResponseException {
        if (this.response.getPartitionNamesCount() != this.response.getPartitionIDsCount() || this.response.getPartitionNamesCount() != this.response.getCreatedUtcTimestampsCount()) {
            throw new IllegalResponseException("Partition information count doesn't match");
        }
        ArrayList<PartitionInfo> results = new ArrayList<PartitionInfo>();
        for (int i = 0; i < this.response.getPartitionNamesCount(); ++i) {
            PartitionInfo info = new PartitionInfo(this.response.getPartitionNames(i), this.response.getPartitionIDs(i), this.response.getCreatedUtcTimestamps(i));
            if (this.response.getInMemoryPercentagesCount() > i) {
                info.setInMemoryPercentage(this.response.getInMemoryPercentages(i));
            }
            results.add(info);
        }
        return results;
    }

    public PartitionInfo getPartitionInfoByName(String partitionName) {
        if (partitionName == null) {
            throw new IllegalArgumentException("Partition name cannot be null");
        }
        for (int i = 0; i < this.response.getPartitionNamesCount(); ++i) {
            if (partitionName.compareTo(this.response.getPartitionNames(i)) != 0) continue;
            PartitionInfo info = new PartitionInfo(this.response.getPartitionNames(i), this.response.getPartitionIDs(i), this.response.getCreatedUtcTimestamps(i));
            if (this.response.getInMemoryPercentagesCount() > i) {
                info.setInMemoryPercentage(this.response.getInMemoryPercentages(i));
            }
            return info;
        }
        return null;
    }

    public String toString() {
        return "Partitions{" + this.getPartitionsInfo().toString() + '}';
    }

    public static final class PartitionInfo {
        private final String name;
        private final long id;
        private final long utcTimestamp;
        private long inMemoryPercentage = 0L;

        public PartitionInfo(String name, long id, long utcTimestamp) {
            this.name = name;
            this.id = id;
            this.utcTimestamp = utcTimestamp;
        }

        public void setInMemoryPercentage(long inMemoryPercentage) {
            this.inMemoryPercentage = inMemoryPercentage;
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public long getUtcTimestamp() {
            return this.utcTimestamp;
        }

        public long getInMemoryPercentage() {
            return this.inMemoryPercentage;
        }

        public String toString() {
            return "(name: " + this.getName() + " id: " + this.getId() + " utcTimestamp: " + this.getUtcTimestamp() + " inMemoryPercentage: " + this.getInMemoryPercentage() + ")";
        }
    }
}

