/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.role;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class SelectRoleParam {
    private final String roleName;
    private final boolean includeUserInfo;

    private SelectRoleParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        if (builder.roleName == null) {
            throw new IllegalArgumentException("Role name cannot be null");
        }
        this.roleName = builder.roleName;
        this.includeUserInfo = builder.includeUserInfo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public boolean isIncludeUserInfo() {
        return this.includeUserInfo;
    }

    public String toString() {
        return "SelectRoleParam{roleName='" + this.roleName + '\'' + ", includeUserInfo=" + this.includeUserInfo + '}';
    }

    public static final class Builder {
        private String roleName;
        private boolean includeUserInfo;

        private Builder() {
        }

        public Builder withRoleName(String roleName) {
            if (roleName == null) {
                throw new IllegalArgumentException("Role name cannot be null");
            }
            this.roleName = roleName;
            return this;
        }

        public Builder withIncludeUserInfo(boolean includeUserInfo) {
            this.includeUserInfo = includeUserInfo;
            return this;
        }

        public SelectRoleParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.roleName, "RoleName");
            return new SelectRoleParam(this);
        }
    }
}

