/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.role;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class RevokeRolePrivilegeParam {
    private final String roleName;
    private final String object;
    private final String objectName;
    private final String privilege;
    private final String databaseName;

    private RevokeRolePrivilegeParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.roleName = builder.roleName;
        this.object = builder.object;
        this.objectName = builder.objectName;
        this.privilege = builder.privilege;
        this.databaseName = builder.databaseName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getObject() {
        return this.object;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getPrivilege() {
        return this.privilege;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        return "RevokeRolePrivilegeParam{roleName='" + this.roleName + '\'' + ", object='" + this.object + '\'' + ", objectName='" + this.objectName + '\'' + ", privilege='" + this.privilege + '\'' + ", databaseName='" + this.databaseName + '\'' + '}';
    }

    public static final class Builder {
        private String roleName;
        private String object;
        private String objectName;
        private String privilege;
        private String databaseName;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withRoleName(String roleName) {
            if (roleName == null || roleName.isEmpty()) {
                throw new IllegalArgumentException("Role name cannot be null or empty");
            }
            this.roleName = roleName;
            return this;
        }

        public Builder withObject(String object) {
            if (object == null || object.isEmpty()) {
                throw new IllegalArgumentException("Object cannot be null or empty");
            }
            this.object = object;
            return this;
        }

        public Builder withObjectName(String objectName) {
            if (objectName == null || objectName.isEmpty()) {
                throw new IllegalArgumentException("Object name cannot be null or empty");
            }
            this.objectName = objectName;
            return this;
        }

        public Builder withPrivilege(String privilege) {
            if (privilege == null || privilege.isEmpty()) {
                throw new IllegalArgumentException("Privilege cannot be null or empty");
            }
            this.privilege = privilege;
            return this;
        }

        public RevokeRolePrivilegeParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.roleName, "RoleName");
            ParamUtils.CheckNullEmptyString(this.object, "Object");
            ParamUtils.CheckNullEmptyString(this.objectName, "ObjectName");
            ParamUtils.CheckNullEmptyString(this.privilege, "Privilege");
            return new RevokeRolePrivilegeParam(this);
        }
    }
}

