/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.role;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class CreateRoleParam {
    private final String roleName;

    private CreateRoleParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.roleName = builder.roleName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String toString() {
        return "CreateRoleParam{roleName='" + this.roleName + '\'' + '}';
    }

    public static final class Builder {
        private String roleName;

        private Builder() {
        }

        public Builder withRoleName(String roleName) {
            if (roleName == null) {
                throw new IllegalArgumentException("Role name cannot be null");
            }
            this.roleName = roleName;
            return this;
        }

        public CreateRoleParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.roleName, "RoleName");
            return new CreateRoleParam(this);
        }
    }
}

