/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.resourcegroup;

import io.milvus.common.resourcegroup.ResourceGroupConfig;
import io.milvus.grpc.UpdateResourceGroupsRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class UpdateResourceGroupsParam {
    private final Map<String, ResourceGroupConfig> resourceGroups;

    private UpdateResourceGroupsParam(Builder builder) {
        if (null == builder.resourceGroups || builder.resourceGroups.isEmpty()) {
            throw new IllegalArgumentException("resourceGroups cannot be empty");
        }
        this.resourceGroups = builder.resourceGroups;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, ResourceGroupConfig> getResourceGroups() {
        return this.resourceGroups;
    }

    public UpdateResourceGroupsRequest toGRPC() {
        UpdateResourceGroupsRequest.Builder builder = UpdateResourceGroupsRequest.newBuilder();
        this.resourceGroups.forEach((k, v) -> builder.putResourceGroups((String)k, v.toGRPC()));
        return builder.build();
    }

    public String toString() {
        return String.format("UpdateResourceGroupsRequest{resourceGroupNames:%s}", this.resourceGroups.keySet().stream().collect(Collectors.joining(",")));
    }

    public static final class Builder {
        private Map<String, ResourceGroupConfig> resourceGroups;

        private Builder() {
        }

        public Builder putResourceGroup(String resourceGroupName, ResourceGroupConfig resourceGroup) {
            if (resourceGroupName == null) {
                throw new IllegalArgumentException("Resource group name cannot be null");
            }
            if (resourceGroup == null) {
                throw new IllegalArgumentException("Resource group cannot be null");
            }
            if (null == this.resourceGroups) {
                this.resourceGroups = new HashMap<String, ResourceGroupConfig>();
            }
            this.resourceGroups.put(resourceGroupName, resourceGroup);
            return this;
        }

        public UpdateResourceGroupsParam build() {
            return new UpdateResourceGroupsParam(this);
        }
    }
}

