/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.resourcegroup;

import io.milvus.common.resourcegroup.ResourceGroupConfig;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class CreateResourceGroupParam {
    private final String groupName;
    private final ResourceGroupConfig config;

    private CreateResourceGroupParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.groupName = builder.groupName;
        this.config = builder.config;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ResourceGroupConfig getConfig() {
        return this.config;
    }

    public String toString() {
        return "CreateResourceGroupParam{groupName='" + this.groupName + '\'' + ", config=" + this.config + '}';
    }

    public static final class Builder {
        private String groupName;
        private ResourceGroupConfig config;

        private Builder() {
        }

        public Builder withGroupName(String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException("Group name cannot be null");
            }
            this.groupName = groupName;
            return this;
        }

        public Builder withConfig(ResourceGroupConfig config) {
            if (config == null) {
                throw new IllegalArgumentException("Config cannot be null");
            }
            this.config = config;
            return this;
        }

        public CreateResourceGroupParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.groupName, "Group name");
            return new CreateResourceGroupParam(this);
        }
    }
}

