/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.index;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import org.apache.commons.lang3.StringUtils;

public class DropIndexParam {
    private final String databaseName;
    private final String collectionName;
    private final String indexName;

    private DropIndexParam(Builder builder) {
        if (builder.collectionName == null) {
            throw new IllegalArgumentException("Collection name cannot be null");
        }
        if (builder.indexName == null) {
            throw new IllegalArgumentException("Index name cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.indexName = builder.indexName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String toString() {
        return "DropIndexParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", indexName='" + this.indexName + '\'' + '}';
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private String indexName = "";

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("Collection name cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withIndexName(String indexName) {
            if (indexName == null) {
                throw new IllegalArgumentException("Index name cannot be null");
            }
            this.indexName = indexName;
            return this;
        }

        public DropIndexParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.indexName == null || StringUtils.isBlank((CharSequence)this.indexName)) {
                this.indexName = "";
            }
            return new DropIndexParam(this);
        }
    }
}

