/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.index;

import io.milvus.exception.ParamException;
import io.milvus.param.Constant;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CreateIndexParam {
    private final String databaseName;
    private final String collectionName;
    private final String fieldName;
    private final String indexName;
    private final IndexType indexType;
    private final Map<String, String> extraParam = new HashMap<String, String>();
    private final boolean syncMode;
    private final long syncWaitingInterval;
    private final long syncWaitingTimeout;

    private CreateIndexParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.fieldName = builder.fieldName;
        this.indexName = builder.indexName;
        this.indexType = builder.indexType;
        if (builder.indexType != IndexType.None) {
            this.extraParam.put("index_type", builder.indexType.getName());
        }
        if (builder.metricType != MetricType.None) {
            this.extraParam.put("metric_type", builder.metricType.name());
        }
        if (builder.extraParam != null) {
            this.extraParam.put("params", builder.extraParam);
        }
        this.syncMode = builder.syncMode;
        this.syncWaitingInterval = builder.syncWaitingInterval;
        this.syncWaitingTimeout = builder.syncWaitingTimeout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public Map<String, String> getExtraParam() {
        return this.extraParam;
    }

    public boolean isSyncMode() {
        return this.syncMode;
    }

    public long getSyncWaitingInterval() {
        return this.syncWaitingInterval;
    }

    public long getSyncWaitingTimeout() {
        return this.syncWaitingTimeout;
    }

    public String toString() {
        return "CreateIndexParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", fieldName='" + this.fieldName + '\'' + ", indexName='" + this.indexName + '\'' + ", indexType=" + (Object)((Object)this.indexType) + ", extraParam=" + this.extraParam + ", syncMode=" + this.syncMode + ", syncWaitingInterval=" + this.syncWaitingInterval + ", syncWaitingTimeout=" + this.syncWaitingTimeout + '}';
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;
        private String fieldName;
        private IndexType indexType = IndexType.None;
        private String indexName = "";
        private MetricType metricType = MetricType.None;
        private String extraParam;
        private Boolean syncMode = Boolean.TRUE;
        private Long syncWaitingInterval = 500L;
        private Long syncWaitingTimeout = 600L;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withFieldName(String fieldName) {
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName cannot be null");
            }
            this.fieldName = fieldName;
            return this;
        }

        public Builder withIndexType(IndexType indexType) {
            if (indexType == null) {
                throw new IllegalArgumentException("indexType cannot be null");
            }
            this.indexType = indexType;
            return this;
        }

        public Builder withIndexName(String indexName) {
            if (indexName == null) {
                throw new IllegalArgumentException("indexName cannot be null");
            }
            this.indexName = indexName;
            return this;
        }

        public Builder withMetricType(MetricType metricType) {
            if (metricType == null) {
                throw new IllegalArgumentException("metricType cannot be null");
            }
            this.metricType = metricType;
            return this;
        }

        public Builder withExtraParam(String extraParam) {
            if (extraParam == null) {
                throw new IllegalArgumentException("extraParam cannot be null");
            }
            this.extraParam = extraParam;
            return this;
        }

        public Builder withSyncMode(Boolean syncMode) {
            if (syncMode == null) {
                throw new IllegalArgumentException("syncMode cannot be null");
            }
            this.syncMode = syncMode;
            return this;
        }

        public Builder withSyncWaitingInterval(Long milliseconds) {
            if (milliseconds == null) {
                throw new IllegalArgumentException("milliseconds cannot be null");
            }
            this.syncWaitingInterval = milliseconds;
            return this;
        }

        public Builder withSyncWaitingTimeout(Long seconds) {
            if (seconds == null) {
                throw new IllegalArgumentException("seconds cannot be null");
            }
            this.syncWaitingTimeout = seconds;
            return this;
        }

        public CreateIndexParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.fieldName, "Field name");
            if (this.indexName == null || StringUtils.isBlank((CharSequence)this.indexName)) {
                this.indexName = "";
            }
            if (Objects.equals(this.syncMode, Boolean.TRUE)) {
                if (this.syncWaitingInterval <= 0L) {
                    throw new ParamException("Sync index waiting interval must be larger than zero");
                }
                if (this.syncWaitingInterval > Constant.MAX_WAITING_INDEX_INTERVAL) {
                    throw new ParamException("Sync index waiting interval cannot be larger than " + Constant.MAX_WAITING_INDEX_INTERVAL.toString() + " milliseconds");
                }
                if (this.syncWaitingTimeout <= 0L) {
                    throw new ParamException("Sync index waiting timeout must be larger than zero");
                }
            }
            return new CreateIndexParam(this);
        }
    }
}

