/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.highlevel.dml;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class DeleteIdsParam {
    private final String collectionName;
    private final String partitionName;
    private final List<?> primaryIds;

    private DeleteIdsParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
        this.primaryIds = builder.primaryIds;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public List<?> getPrimaryIds() {
        return this.primaryIds;
    }

    public String toString() {
        return "DeleteIdsParam{collectionName='" + this.collectionName + '\'' + ", partitionName='" + this.partitionName + '\'' + ", primaryIds=" + this.primaryIds + '}';
    }

    public static class Builder<T> {
        private String collectionName;
        private String partitionName = "";
        private List<T> primaryIds = new ArrayList<T>();

        private Builder() {
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(String partitionName) {
            if (partitionName == null) {
                throw new IllegalArgumentException("partitionName cannot be null");
            }
            this.partitionName = partitionName;
            return this;
        }

        public Builder withPrimaryIds(List<T> primaryIds) {
            if (primaryIds == null) {
                throw new IllegalArgumentException("primaryIds cannot be null");
            }
            this.primaryIds.addAll(primaryIds);
            return this;
        }

        public Builder addPrimaryId(T primaryId) {
            if (primaryId == null) {
                throw new IllegalArgumentException("primaryId cannot be null");
            }
            this.primaryIds.add(primaryId);
            return this;
        }

        public DeleteIdsParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (CollectionUtils.isEmpty(this.primaryIds)) {
                throw new ParamException("PrimaryIds cannot be empty");
            }
            return new DeleteIdsParam(this);
        }
    }
}

