/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml.ranker;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.milvus.common.utils.JsonUtils;
import io.milvus.exception.ParamException;
import io.milvus.param.dml.ranker.BaseRanker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WeightedRanker
extends BaseRanker {
    private final List<Float> weights;

    private WeightedRanker(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.weights = builder.weights;
    }

    public List<Float> getWeights() {
        return this.weights;
    }

    public String toString() {
        return "WeightedRanker{weights=" + this.weights + '}';
    }

    @Override
    public Map<String, String> getProperties() {
        JsonObject params = new JsonObject();
        params.add("weights", (JsonElement)JsonUtils.toJsonTree(this.weights).getAsJsonArray());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("strategy", "weighted");
        props.put("params", params.toString());
        return props;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<Float> weights = new ArrayList<Float>();

        private Builder() {
        }

        public Builder withWeights(List<Float> weights) {
            if (weights == null) {
                throw new IllegalArgumentException("weights cannot be null");
            }
            this.weights = weights;
            return this;
        }

        public WeightedRanker build() throws ParamException {
            return new WeightedRanker(this);
        }
    }
}

