/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.grpc.PlaceholderType;
import io.milvus.param.Constant;
import io.milvus.param.MetricType;
import io.milvus.param.ParamUtils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.SortedMap;

public class SearchParam {
    private String databaseName;
    private final String collectionName;
    private final List<String> partitionNames;
    private final String metricType;
    private final String vectorFieldName;
    private final Long topK;
    private final String expr;
    private final List<String> outFields;
    private final List<?> vectors;
    private final Long NQ;
    private final int roundDecimal;
    private final String params;
    private final long travelTimestamp;
    private final long guaranteeTimestamp;
    private final Long gracefulTime;
    private final ConsistencyLevelEnum consistencyLevel;
    private final boolean ignoreGrowing;
    private final String groupByFieldName;
    private final Integer groupSize;
    private final Boolean strictGroupSize;
    private final PlaceholderType plType;

    private SearchParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.metricType = builder.metricType.name();
        this.vectorFieldName = builder.vectorFieldName;
        this.topK = builder.topK;
        this.expr = builder.expr;
        this.outFields = builder.outFields;
        this.vectors = builder.vectors;
        this.NQ = builder.NQ;
        this.roundDecimal = builder.roundDecimal;
        this.params = builder.params;
        this.travelTimestamp = builder.travelTimestamp;
        this.guaranteeTimestamp = builder.guaranteeTimestamp;
        this.gracefulTime = builder.gracefulTime;
        this.consistencyLevel = builder.consistencyLevel;
        this.ignoreGrowing = builder.ignoreGrowing;
        this.groupByFieldName = builder.groupByFieldName;
        this.groupSize = builder.groupSize;
        this.strictGroupSize = builder.strictGroupSize;
        this.plType = builder.plType;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public Long getTopK() {
        return this.topK;
    }

    public String getExpr() {
        return this.expr;
    }

    public List<String> getOutFields() {
        return this.outFields;
    }

    public List<?> getVectors() {
        return this.vectors;
    }

    public Long getNQ() {
        return this.NQ;
    }

    public int getRoundDecimal() {
        return this.roundDecimal;
    }

    public String getParams() {
        return this.params;
    }

    public long getTravelTimestamp() {
        return this.travelTimestamp;
    }

    public long getGuaranteeTimestamp() {
        return this.guaranteeTimestamp;
    }

    public Long getGracefulTime() {
        return this.gracefulTime;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public boolean isIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public String getGroupByFieldName() {
        return this.groupByFieldName;
    }

    public Integer getGroupSize() {
        return this.groupSize;
    }

    public Boolean getStrictGroupSize() {
        return this.strictGroupSize;
    }

    public PlaceholderType getPlType() {
        return this.plType;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static void verifyVectors(List<?> vectors) {
        if (vectors == null || vectors.isEmpty()) {
            throw new ParamException("Target vectors can not be empty");
        }
        if (vectors.get(0) instanceof List) {
            List first = (List)vectors.get(0);
            if (!(first.get(0) instanceof Float)) {
                throw new ParamException("Float vector field's value must be Lst<Float>");
            }
            int dim = first.size();
            for (int i = 1; i < vectors.size(); ++i) {
                List temp = (List)vectors.get(i);
                if (dim == temp.size()) continue;
                throw new ParamException("Target vector dimension must be equal");
            }
        } else if (vectors.get(0) instanceof ByteBuffer) {
            ByteBuffer first = (ByteBuffer)vectors.get(0);
            int len = first.limit();
            for (int i = 1; i < vectors.size(); ++i) {
                ByteBuffer temp = (ByteBuffer)vectors.get(i);
                if (len == temp.limit()) continue;
                throw new ParamException("Target vector dimension must be equal");
            }
        } else if (vectors.get(0) instanceof SortedMap) {
            SortedMap map = (SortedMap)vectors.get(0);
            if (!(map.firstKey() instanceof Long)) {
                throw new ParamException("key type of SparseFloatVector must be Long");
            }
            if (!(map.get(map.firstKey()) instanceof Float)) {
                throw new ParamException("Value type of SparseFloatVector must be Float");
            }
        } else {
            String msg = "Search target vector type is illegal. Only allow List<Float> for FloatVector, ByteBuffer for BinaryVector/Float16Vector/BFloat16Vector, List<SortedMap<Long, Float>> for SparseFloatVector.";
            throw new ParamException(msg);
        }
    }

    public String toString() {
        return "SearchParam{collectionName='" + this.collectionName + '\'' + ", databaseName='" + this.databaseName + '\'' + ", partitionNamesCount='" + this.partitionNames.size() + '\'' + ", metricType=" + this.metricType + ", vectorFieldName='" + this.vectorFieldName + '\'' + ", expr='" + this.expr + '\'' + ", topK=" + this.topK + ", nq=" + this.NQ + ", expr='" + this.expr + '\'' + ", params='" + this.params + '\'' + ", outputFields=" + this.outFields + ", consistencyLevel='" + (Object)((Object)this.consistencyLevel) + '\'' + ", ignoreGrowing='" + this.ignoreGrowing + '\'' + '}';
    }

    public static class Builder {
        private String databaseName;
        private String collectionName;
        private final List<String> partitionNames = Lists.newArrayList();
        private MetricType metricType = MetricType.None;
        private String vectorFieldName;
        private Long topK;
        private String expr = "";
        private final List<String> outFields = Lists.newArrayList();
        private List<?> vectors;
        private Long NQ;
        private Integer roundDecimal = -1;
        private String params = "{}";
        private Long travelTimestamp = 0L;
        private Long guaranteeTimestamp = Constant.GUARANTEE_EVENTUALLY_TS;
        private Long gracefulTime = 5000L;
        private ConsistencyLevelEnum consistencyLevel = null;
        private Boolean ignoreGrowing = Boolean.FALSE;
        private String groupByFieldName;
        private Integer groupSize = null;
        private Boolean strictGroupSize = null;
        private PlaceholderType plType = PlaceholderType.None;

        Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionNames(List<String> partitionNames) {
            if (partitionNames == null) {
                throw new IllegalArgumentException("partitionNames cannot be null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder addPartitionName(String partitionName) {
            if (partitionName == null) {
                throw new IllegalArgumentException("partitionName cannot be null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public Builder withMetricType(MetricType metricType) {
            if (metricType == null) {
                throw new IllegalArgumentException("metricType cannot be null");
            }
            this.metricType = metricType;
            return this;
        }

        public Builder withVectorFieldName(String vectorFieldName) {
            if (vectorFieldName == null) {
                throw new IllegalArgumentException("vectorFieldName cannot be null");
            }
            this.vectorFieldName = vectorFieldName;
            return this;
        }

        @Deprecated
        public Builder withTopK(Integer topK) {
            if (topK == null) {
                throw new IllegalArgumentException("topK cannot be null");
            }
            this.topK = topK.longValue();
            return this;
        }

        public Builder withLimit(Long limit) {
            if (limit == null) {
                throw new IllegalArgumentException("limit cannot be null");
            }
            this.topK = limit;
            return this;
        }

        public Builder withExpr(String expr) {
            if (expr == null) {
                throw new IllegalArgumentException("expr cannot be null");
            }
            this.expr = expr;
            return this;
        }

        public Builder withOutFields(List<String> outFields) {
            if (outFields == null) {
                throw new IllegalArgumentException("outFields cannot be null");
            }
            outFields.forEach(this::addOutField);
            return this;
        }

        public Builder addOutField(String fieldName) {
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName cannot be null");
            }
            if (!this.outFields.contains(fieldName)) {
                this.outFields.add(fieldName);
            }
            return this;
        }

        @Deprecated
        public Builder withVectors(List<?> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            return this;
        }

        public Builder withFloatVectors(List<List<Float>> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.FloatVector;
            return this;
        }

        public Builder withBinaryVectors(List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.BinaryVector;
            return this;
        }

        public Builder withFloat16Vectors(List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.Float16Vector;
            return this;
        }

        public Builder withBFloat16Vectors(List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.BFloat16Vector;
            return this;
        }

        public Builder withSparseFloatVectors(List<SortedMap<Long, Float>> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.SparseFloatVector;
            return this;
        }

        public Builder withRoundDecimal(Integer decimal) {
            if (decimal == null) {
                throw new IllegalArgumentException("decimal cannot be null");
            }
            this.roundDecimal = decimal;
            return this;
        }

        public Builder withParams(String params) {
            if (params == null) {
                throw new IllegalArgumentException("params cannot be null");
            }
            this.params = params;
            return this;
        }

        public Builder withIgnoreGrowing(Boolean ignoreGrowing) {
            if (ignoreGrowing == null) {
                throw new IllegalArgumentException("ignoreGrowing cannot be null");
            }
            this.ignoreGrowing = ignoreGrowing;
            return this;
        }

        public Builder withGroupByFieldName(String groupByFieldName) {
            if (groupByFieldName == null) {
                throw new IllegalArgumentException("groupByFieldName cannot be null");
            }
            this.groupByFieldName = groupByFieldName;
            return this;
        }

        public Builder withGroupSize(Integer groupSize) {
            if (groupSize == null) {
                throw new IllegalArgumentException("groupSize cannot be null");
            }
            this.groupSize = groupSize;
            return this;
        }

        public Builder withStrictGroupSize(Boolean strictGroupSize) {
            if (strictGroupSize == null) {
                throw new IllegalArgumentException("strictGroupSize cannot be null");
            }
            this.strictGroupSize = strictGroupSize;
            return this;
        }

        public SearchParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.vectorFieldName, "Target field name");
            if (this.topK <= 0L) {
                throw new ParamException("TopK value is illegal");
            }
            if (this.travelTimestamp < 0L) {
                throw new ParamException("The travel timestamp must be greater than 0");
            }
            if (this.guaranteeTimestamp < 0L) {
                throw new ParamException("The guarantee timestamp must be greater than 0");
            }
            SearchParam.verifyVectors(this.vectors);
            if (this.groupByFieldName != null && this.groupSize != null && this.groupSize <= 0) {
                throw new ParamException("GroupSize value cannot be zero or negative");
            }
            return new SearchParam(this);
        }
    }
}

