/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.google.common.collect.Lists;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.exception.ParamException;
import io.milvus.grpc.PlaceholderType;
import io.milvus.param.Constant;
import io.milvus.param.MetricType;
import io.milvus.param.ParamUtils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;

public class SearchIteratorParam {
    private final String databaseName;
    private final String collectionName;
    private final List<String> partitionNames;
    private final String metricType;
    private final String vectorFieldName;
    private final Long topK;
    private final String expr;
    private final List<String> outFields;
    private final List<?> vectors;
    private final Long NQ;
    private final int roundDecimal;
    private final String params;
    private final long travelTimestamp;
    private final long guaranteeTimestamp;
    private final Long gracefulTime;
    private final ConsistencyLevelEnum consistencyLevel;
    private final boolean ignoreGrowing;
    private final String groupByFieldName;
    private final PlaceholderType plType;
    private final long batchSize;

    private SearchIteratorParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionNames = builder.partitionNames;
        this.metricType = builder.metricType.name();
        this.vectorFieldName = builder.vectorFieldName;
        this.topK = builder.topK;
        this.expr = builder.expr;
        this.outFields = builder.outFields;
        this.vectors = builder.vectors;
        this.NQ = builder.NQ;
        this.roundDecimal = builder.roundDecimal;
        this.params = builder.params;
        this.travelTimestamp = builder.travelTimestamp;
        this.guaranteeTimestamp = builder.guaranteeTimestamp;
        this.gracefulTime = builder.gracefulTime;
        this.consistencyLevel = builder.consistencyLevel;
        this.ignoreGrowing = builder.ignoreGrowing;
        this.groupByFieldName = builder.groupByFieldName;
        this.plType = builder.plType;
        this.batchSize = builder.batchSize;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public String getMetricType() {
        return this.metricType;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public Long getTopK() {
        return this.topK;
    }

    public String getExpr() {
        return this.expr;
    }

    public List<String> getOutFields() {
        return this.outFields;
    }

    public List<?> getVectors() {
        return this.vectors;
    }

    public Long getNQ() {
        return this.NQ;
    }

    public int getRoundDecimal() {
        return this.roundDecimal;
    }

    public String getParams() {
        return this.params;
    }

    public long getTravelTimestamp() {
        return this.travelTimestamp;
    }

    public long getGuaranteeTimestamp() {
        return this.guaranteeTimestamp;
    }

    public Long getGracefulTime() {
        return this.gracefulTime;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public boolean isIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public String getGroupByFieldName() {
        return this.groupByFieldName;
    }

    public PlaceholderType getPlType() {
        return this.plType;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public String toString() {
        return "SearchIteratorParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", partitionNames=" + this.partitionNames + ", metricType='" + this.metricType + '\'' + ", vectorFieldName='" + this.vectorFieldName + '\'' + ", topK=" + this.topK + ", expr='" + this.expr + '\'' + ", outFields=" + this.outFields + ", NQ=" + this.NQ + ", roundDecimal=" + this.roundDecimal + ", params='" + this.params + '\'' + ", travelTimestamp=" + this.travelTimestamp + ", guaranteeTimestamp=" + this.guaranteeTimestamp + ", gracefulTime=" + this.gracefulTime + ", consistencyLevel=" + (Object)((Object)this.consistencyLevel) + ", ignoreGrowing=" + this.ignoreGrowing + ", groupByFieldName='" + this.groupByFieldName + '\'' + ", plType=" + (Object)((Object)this.plType) + ", batchSize=" + this.batchSize + '}';
    }

    public static void verifyVectors(List<?> vectors) {
        if (vectors == null || vectors.isEmpty()) {
            throw new ParamException("Target vectors can not be empty");
        }
        if (vectors.get(0) instanceof List) {
            if (vectors.size() > 1) {
                throw new ParamException("Not support search iteration over multiple vectors at present");
            }
            List first = (List)vectors.get(0);
            if (!(first.get(0) instanceof Float)) {
                throw new ParamException("Float vector field's value must be Lst<Float>");
            }
        } else if (vectors.get(0) instanceof ByteBuffer) {
            if (vectors.size() > 1) {
                throw new ParamException("Not support search iteration over multiple vectors at present");
            }
        } else if (vectors.get(0) instanceof SortedMap) {
            if (vectors.size() > 1) {
                throw new ParamException("Not support search iteration over multiple vectors at present");
            }
            SortedMap map = (SortedMap)vectors.get(0);
            if (!(map.firstKey() instanceof Long)) {
                throw new ParamException("key type of SparseFloatVector must be Long");
            }
            if (!(map.get(map.firstKey()) instanceof Float)) {
                throw new ParamException("Value type of SparseFloatVector must be Float");
            }
        } else {
            String msg = "Search target vector type is illegal. Only allow List<Float> for FloatVector, ByteBuffer for BinaryVector/Float16Vector/BFloat16Vector, List<SortedMap<Long, Float>> for SparseFloatVector.";
            throw new ParamException(msg);
        }
    }

    public static class Builder {
        private String databaseName;
        private String collectionName;
        private final List<String> partitionNames = Lists.newArrayList();
        private MetricType metricType = MetricType.None;
        private String vectorFieldName;
        private Long topK = -1L;
        private String expr = "";
        private final List<String> outFields = Lists.newArrayList();
        private List<?> vectors;
        private Long NQ;
        private Integer roundDecimal = -1;
        private String params = "{}";
        private Long travelTimestamp = 0L;
        private Long guaranteeTimestamp = Constant.GUARANTEE_EVENTUALLY_TS;
        private Long gracefulTime = 5000L;
        private ConsistencyLevelEnum consistencyLevel = null;
        private Boolean ignoreGrowing = Boolean.FALSE;
        private String groupByFieldName;
        private PlaceholderType plType = PlaceholderType.None;
        private Long batchSize = 1000L;

        Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionNames(List<String> partitionNames) {
            if (partitionNames == null) {
                throw new IllegalArgumentException("partitionNames cannot be null");
            }
            partitionNames.forEach(this::addPartitionName);
            return this;
        }

        public Builder withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public Builder addPartitionName(String partitionName) {
            if (partitionName == null) {
                throw new IllegalArgumentException("partitionName cannot be null");
            }
            if (!this.partitionNames.contains(partitionName)) {
                this.partitionNames.add(partitionName);
            }
            return this;
        }

        public Builder withMetricType(MetricType metricType) {
            if (metricType == null) {
                throw new IllegalArgumentException("metricType cannot be null");
            }
            this.metricType = metricType;
            return this;
        }

        public Builder withVectorFieldName(String vectorFieldName) {
            if (vectorFieldName == null) {
                throw new IllegalArgumentException("vectorFieldName cannot be null");
            }
            this.vectorFieldName = vectorFieldName;
            return this;
        }

        @Deprecated
        public Builder withTopK(Integer topK) {
            if (topK == null) {
                throw new IllegalArgumentException("topK cannot be null");
            }
            this.topK = topK.longValue();
            return this;
        }

        public Builder withLimit(Long limit) {
            if (limit == null) {
                throw new IllegalArgumentException("limit cannot be null");
            }
            this.topK = limit;
            return this;
        }

        public Builder withExpr(String expr) {
            if (expr == null) {
                throw new IllegalArgumentException("expr cannot be null");
            }
            this.expr = expr;
            return this;
        }

        public Builder withOutFields(List<String> outFields) {
            if (outFields == null) {
                throw new IllegalArgumentException("outFields cannot be null");
            }
            outFields.forEach(this::addOutField);
            return this;
        }

        public Builder addOutField(String fieldName) {
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName cannot be null");
            }
            if (!this.outFields.contains(fieldName)) {
                this.outFields.add(fieldName);
            }
            return this;
        }

        @Deprecated
        public Builder withVectors(List<?> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            return this;
        }

        public Builder withFloatVectors(List<List<Float>> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.FloatVector;
            return this;
        }

        public Builder withBinaryVectors(List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.BinaryVector;
            return this;
        }

        public Builder withFloat16Vectors(List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.Float16Vector;
            return this;
        }

        public Builder withBFloat16Vectors(List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.BFloat16Vector;
            return this;
        }

        public Builder withSparseFloatVectors(List<SortedMap<Long, Float>> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("vectors cannot be null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.SparseFloatVector;
            return this;
        }

        public Builder withRoundDecimal(Integer decimal) {
            if (decimal == null) {
                throw new IllegalArgumentException("decimal cannot be null");
            }
            this.roundDecimal = decimal;
            return this;
        }

        public Builder withParams(String params) {
            if (params == null) {
                throw new IllegalArgumentException("params cannot be null");
            }
            this.params = params;
            return this;
        }

        public Builder withIgnoreGrowing(Boolean ignoreGrowing) {
            if (ignoreGrowing == null) {
                throw new IllegalArgumentException("ignoreGrowing cannot be null");
            }
            this.ignoreGrowing = ignoreGrowing;
            return this;
        }

        public Builder withGroupByFieldName(String groupByFieldName) {
            if (groupByFieldName == null) {
                throw new IllegalArgumentException("groupByFieldName cannot be null");
            }
            this.groupByFieldName = groupByFieldName;
            return this;
        }

        public Builder withBatchSize(@NotNull Long batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public SearchIteratorParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.vectorFieldName, "Target field name");
            if (this.topK != -1L && this.topK <= 0L) {
                throw new ParamException("TopK value is illegal");
            }
            if (this.travelTimestamp < 0L) {
                throw new ParamException("The travel timestamp must be greater than 0");
            }
            if (this.guaranteeTimestamp < 0L) {
                throw new ParamException("The guarantee timestamp must be greater than 0");
            }
            if (this.metricType == MetricType.None) {
                throw new ParamException("must specify metricType for search iterator");
            }
            SearchIteratorParam.verifyVectors(this.vectors);
            return new SearchIteratorParam(this);
        }
    }
}

