/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.control;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class GetReplicasParam {
    private final String databaseName;
    private final String collectionName;
    private boolean withShardNodes;

    private GetReplicasParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder cannot be null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.withShardNodes = true;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean isWithShardNodes() {
        return this.withShardNodes;
    }

    public String toString() {
        return "GetReplicasParam{databaseName='" + this.databaseName + '\'' + ", collectionName='" + this.collectionName + '\'' + ", withShardNodes=" + this.withShardNodes + '}';
    }

    public static final class Builder {
        private String databaseName;
        private String collectionName;

        private Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            if (databaseName == null) {
                throw new IllegalArgumentException("databaseName cannot be null");
            }
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public GetReplicasParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new GetReplicasParam(this);
        }
    }
}

