/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class RenameCollectionParam {
    private final String oldDatabaseName;
    private final String newDatabaseName;
    private final String oldCollectionName;
    private final String newCollectionName;

    public RenameCollectionParam(Builder builder) {
        if (builder.oldCollectionName == null) {
            throw new IllegalArgumentException("oldCollectionName cannot be null");
        }
        if (builder.newCollectionName == null) {
            throw new IllegalArgumentException("newCollectionName cannot be null");
        }
        this.oldDatabaseName = builder.oldDatabaseName;
        this.newDatabaseName = builder.newDatabaseName;
        this.oldCollectionName = builder.oldCollectionName;
        this.newCollectionName = builder.newCollectionName;
    }

    public String getOldCollectionName() {
        return this.oldCollectionName;
    }

    public String getNewCollectionName() {
        return this.newCollectionName;
    }

    public String getOldDatabaseName() {
        return this.oldDatabaseName;
    }

    public String getNewDatabaseName() {
        return this.newDatabaseName;
    }

    public String toString() {
        return "RenameCollectionParam{oldCollectionName='" + this.oldCollectionName + '\'' + ", newCollectionName='" + this.newCollectionName + '\'' + ", oldDatabaseName='" + this.oldDatabaseName + '\'' + ", newDatabaseName='" + this.newDatabaseName + '\'' + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String oldDatabaseName;
        private String newDatabaseName;
        private String oldCollectionName;
        private String newCollectionName;

        private Builder() {
        }

        public Builder withOldDatabaseName(String oldDatabaseName) {
            this.oldDatabaseName = oldDatabaseName;
            return this;
        }

        public Builder withNewDatabaseName(String newDatabaseName) {
            this.newDatabaseName = newDatabaseName;
            return this;
        }

        public Builder withOldCollectionName(String oldCollectionName) {
            if (oldCollectionName == null) {
                throw new IllegalArgumentException("oldCollectionName cannot be null");
            }
            this.oldCollectionName = oldCollectionName;
            return this;
        }

        public Builder withNewCollectionName(String newCollectionName) {
            if (newCollectionName == null) {
                throw new IllegalArgumentException("newCollectionName cannot be null");
            }
            this.newCollectionName = newCollectionName;
            return this;
        }

        public RenameCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.oldCollectionName, "Old collection name");
            ParamUtils.CheckNullEmptyString(this.newCollectionName, "New collection name");
            return new RenameCollectionParam(this);
        }
    }
}

