/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.collection;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;

public class DropCollectionParam {
    private final String collectionName;
    private final String databaseName;

    private DropCollectionParam(Builder builder) {
        if (builder.collectionName == null) {
            throw new IllegalArgumentException("collectionName cannot be null");
        }
        this.collectionName = builder.collectionName;
        this.databaseName = builder.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        return "DropCollectionParam{collectionName='" + this.collectionName + '\'' + ", databaseName='" + this.databaseName + '\'' + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String collectionName;
        private String databaseName;

        private Builder() {
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("collectionName cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public DropCollectionParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new DropCollectionParam(this);
        }
    }
}

