/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import io.milvus.exception.ParamException;

public class RetryParam {
    private int maxRetryTimes;
    private long initialBackOffMs;
    private long maxBackOffMs;
    private int backOffMultiplier;
    private boolean retryOnRateLimit;

    protected RetryParam(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.maxRetryTimes = builder.maxRetryTimes;
        this.initialBackOffMs = builder.initialBackOffMs;
        this.maxBackOffMs = builder.maxBackOffMs;
        this.backOffMultiplier = builder.backOffMultiplier;
        this.retryOnRateLimit = builder.retryOnRateLimit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public long getInitialBackOffMs() {
        return this.initialBackOffMs;
    }

    public void setInitialBackOffMs(long initialBackOffMs) {
        this.initialBackOffMs = initialBackOffMs;
    }

    public long getMaxBackOffMs() {
        return this.maxBackOffMs;
    }

    public void setMaxBackOffMs(long maxBackOffMs) {
        this.maxBackOffMs = maxBackOffMs;
    }

    public int getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(int backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public boolean isRetryOnRateLimit() {
        return this.retryOnRateLimit;
    }

    public void setRetryOnRateLimit(boolean retryOnRateLimit) {
        this.retryOnRateLimit = retryOnRateLimit;
    }

    public String toString() {
        return "RetryParam{maxRetryTimes=" + this.maxRetryTimes + ", initialBackOffMs=" + this.initialBackOffMs + ", maxBackOffMs=" + this.maxBackOffMs + ", backOffMultiplier=" + this.backOffMultiplier + ", retryOnRateLimit=" + this.retryOnRateLimit + '}';
    }

    public static class Builder {
        private int maxRetryTimes = 75;
        private long initialBackOffMs = 10L;
        private long maxBackOffMs = 3000L;
        private int backOffMultiplier = 3;
        private boolean retryOnRateLimit = true;

        protected Builder() {
        }

        public int getMaxRetryTimes() {
            return this.maxRetryTimes;
        }

        public long getInitialBackOffMs() {
            return this.initialBackOffMs;
        }

        public long getMaxBackOffMs() {
            return this.maxBackOffMs;
        }

        public int getBackOffMultiplier() {
            return this.backOffMultiplier;
        }

        public boolean isRetryOnRateLimit() {
            return this.retryOnRateLimit;
        }

        public Builder withMaxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public Builder withInitialBackOffMs(long initialBackOffMs) {
            this.initialBackOffMs = initialBackOffMs;
            return this;
        }

        public Builder withMaxBackOffMs(long maxBackOffMs) {
            this.maxBackOffMs = maxBackOffMs;
            return this;
        }

        public Builder withBackOffMultiplier(int backOffMultiplier) {
            this.backOffMultiplier = backOffMultiplier;
            return this;
        }

        public Builder withRetryOnRateLimit(boolean retryOnRateLimit) {
            this.retryOnRateLimit = retryOnRateLimit;
            return this;
        }

        public RetryParam build() throws ParamException {
            if ((long)this.maxRetryTimes <= 0L) {
                throw new ParamException("Max retry time value must be positive!");
            }
            if (this.initialBackOffMs <= 0L) {
                throw new ParamException("The initial time interval must be positive!");
            }
            if (this.maxBackOffMs <= 0L) {
                throw new ParamException("The max time interval must be positive!");
            }
            if ((long)this.backOffMultiplier <= 0L) {
                throw new ParamException("The multiplier to increase time interval must be positive!");
            }
            return new RetryParam(this);
        }
    }
}

