/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import io.milvus.exception.ParamException;
import io.milvus.param.MetricType;
import io.milvus.param.ParamUtils;
import java.nio.ByteBuffer;
import java.util.List;

public class QueryNodeSingleSearch {
    private final String collectionName;
    private final MetricType metricType;
    private final String vectorFieldName;
    private final List<?> vectors;
    private final String params;

    private QueryNodeSingleSearch(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.collectionName = builder.collectionName;
        this.metricType = builder.metricType;
        this.vectorFieldName = builder.vectorFieldName;
        this.vectors = builder.vectors;
        this.params = builder.params;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public List<?> getVectors() {
        return this.vectors;
    }

    public String getParams() {
        return this.params;
    }

    public static class Builder {
        private String collectionName;
        private MetricType metricType = MetricType.L2;
        private String vectorFieldName;
        private List<?> vectors;
        private String params = "{}";

        private Builder() {
        }

        public Builder withCollectionName(String collectionName) {
            if (collectionName == null) {
                throw new IllegalArgumentException("Collection name cannot be null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withMetricType(MetricType metricType) {
            if (metricType == null) {
                throw new IllegalArgumentException("Metric type cannot be null");
            }
            this.metricType = metricType;
            return this;
        }

        public Builder withVectorFieldName(String vectorFieldName) {
            if (vectorFieldName == null) {
                throw new IllegalArgumentException("Vector field name cannot be null");
            }
            this.vectorFieldName = vectorFieldName;
            return this;
        }

        public Builder withVectors(List<?> vectors) {
            if (vectors == null) {
                throw new IllegalArgumentException("Vectors cannot be null");
            }
            this.vectors = vectors;
            return this;
        }

        public Builder withParams(String params) {
            if (params == null) {
                throw new IllegalArgumentException("Params cannot be null");
            }
            this.params = params;
            return this;
        }

        public QueryNodeSingleSearch build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            ParamUtils.CheckNullEmptyString(this.vectorFieldName, "Target field name");
            if (this.vectors == null || this.vectors.isEmpty()) {
                throw new ParamException("Target vectors can not be empty");
            }
            if (this.vectors.get(0) instanceof List) {
                List first = (List)this.vectors.get(0);
                if (!(first.get(0) instanceof Float)) {
                    throw new ParamException("Float vector field's value must be List<Float>");
                }
                int dim = first.size();
                for (int i = 1; i < this.vectors.size(); ++i) {
                    List temp = (List)this.vectors.get(i);
                    if (dim == temp.size()) continue;
                    throw new ParamException("Target vector dimension must be equal");
                }
            } else if (this.vectors.get(0) instanceof ByteBuffer) {
                ByteBuffer first = (ByteBuffer)this.vectors.get(0);
                int dim = first.limit();
                for (int i = 1; i < this.vectors.size(); ++i) {
                    ByteBuffer temp = (ByteBuffer)this.vectors.get(i);
                    if (dim == temp.limit()) continue;
                    throw new ParamException("Target vector dimension must be equal");
                }
            } else {
                throw new ParamException("Target vector type must be List<Float> or ByteBuffer");
            }
            return new QueryNodeSingleSearch(this);
        }
    }
}

