/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param;

import com.google.common.collect.Lists;
import io.milvus.exception.ParamException;
import io.milvus.param.ConnectParam;
import io.milvus.param.ParamUtils;
import io.milvus.param.QueryNodeSingleSearch;
import io.milvus.param.ServerAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;

public class MultiConnectParam
extends ConnectParam {
    private final List<ServerAddress> hosts;
    private final QueryNodeSingleSearch queryNodeSingleSearch;

    private MultiConnectParam(Builder builder) {
        super(builder);
        if (builder == null) {
            throw new IllegalArgumentException("Builder cannot be null");
        }
        this.hosts = builder.hosts;
        this.queryNodeSingleSearch = builder.queryNodeSingleSearch;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<ServerAddress> getHosts() {
        return this.hosts;
    }

    public QueryNodeSingleSearch getQueryNodeSingleSearch() {
        return this.queryNodeSingleSearch;
    }

    @Override
    public String toString() {
        return "MultiConnectParam{hosts=" + this.hosts + ", queryNodeSingleSearch=" + this.queryNodeSingleSearch + ", " + super.toString() + '}';
    }

    public static class Builder
    extends ConnectParam.Builder {
        private List<ServerAddress> hosts;
        private QueryNodeSingleSearch queryNodeSingleSearch;

        private Builder() {
        }

        public Builder withHosts(List<ServerAddress> hosts) {
            if (hosts == null) {
                throw new IllegalArgumentException("Hosts cannot be null");
            }
            this.hosts = hosts;
            return this;
        }

        public Builder withQueryNodeSingleSearch(QueryNodeSingleSearch queryNodeSingleSearch) {
            if (queryNodeSingleSearch == null) {
                throw new IllegalArgumentException("Query node single search cannot be null");
            }
            this.queryNodeSingleSearch = queryNodeSingleSearch;
            return this;
        }

        @Override
        public Builder withHost(String host) {
            if (host == null) {
                throw new IllegalArgumentException("Host cannot be null");
            }
            super.withHost(host);
            return this;
        }

        @Override
        public Builder withPort(int port) {
            super.withPort(port);
            return this;
        }

        @Override
        public Builder withDatabaseName(String databaseName) {
            super.withDatabaseName(databaseName);
            return this;
        }

        @Override
        public Builder withUri(String uri) {
            super.withUri(uri);
            return this;
        }

        @Override
        public Builder withToken(String token) {
            super.withToken(token);
            return this;
        }

        @Override
        public Builder withConnectTimeout(long connectTimeout, TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new IllegalArgumentException("TimeUnit cannot be null");
            }
            super.withConnectTimeout(connectTimeout, timeUnit);
            return this;
        }

        @Override
        public Builder withKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new IllegalArgumentException("TimeUnit cannot be null");
            }
            super.withKeepAliveTime(keepAliveTime, timeUnit);
            return this;
        }

        @Override
        public Builder withKeepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new IllegalArgumentException("TimeUnit cannot be null");
            }
            super.withKeepAliveTimeout(keepAliveTimeout, timeUnit);
            return this;
        }

        @Override
        public Builder keepAliveWithoutCalls(boolean enable) {
            super.keepAliveWithoutCalls(enable);
            return this;
        }

        @Override
        public Builder withIdleTimeout(long idleTimeout, TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new IllegalArgumentException("TimeUnit cannot be null");
            }
            super.withIdleTimeout(idleTimeout, timeUnit);
            return this;
        }

        @Override
        public Builder withRpcDeadline(long deadline, TimeUnit timeUnit) {
            if (timeUnit == null) {
                throw new IllegalArgumentException("TimeUnit cannot be null");
            }
            super.withRpcDeadline(deadline, timeUnit);
            return this;
        }

        @Override
        public Builder withAuthorization(String username, String password) {
            super.withAuthorization(username, password);
            return this;
        }

        @Override
        public Builder withSecure(boolean secure) {
            super.withSecure(secure);
            return this;
        }

        @Override
        public Builder withAuthorization(String authorization) {
            if (authorization == null) {
                throw new IllegalArgumentException("Authorization cannot be null");
            }
            super.withAuthorization(authorization);
            return this;
        }

        @Override
        public Builder withClientKeyPath(String clientKeyPath) {
            if (clientKeyPath == null) {
                throw new IllegalArgumentException("Client key path cannot be null");
            }
            super.withClientKeyPath(clientKeyPath);
            return this;
        }

        @Override
        public Builder withClientPemPath(String clientPemPath) {
            if (clientPemPath == null) {
                throw new IllegalArgumentException("Client pem path cannot be null");
            }
            super.withClientPemPath(clientPemPath);
            return this;
        }

        @Override
        public Builder withCaPemPath(String caPemPath) {
            if (caPemPath == null) {
                throw new IllegalArgumentException("CA pem path cannot be null");
            }
            super.withCaPemPath(caPemPath);
            return this;
        }

        @Override
        public Builder withServerPemPath(String serverPemPath) {
            if (serverPemPath == null) {
                throw new IllegalArgumentException("Server pem path cannot be null");
            }
            super.withServerPemPath(serverPemPath);
            return this;
        }

        @Override
        public Builder withServerName(String serverName) {
            if (serverName == null) {
                throw new IllegalArgumentException("Server name cannot be null");
            }
            super.withServerName(serverName);
            return this;
        }

        @Override
        public MultiConnectParam build() throws ParamException {
            super.verify();
            if (CollectionUtils.isEmpty(this.hosts)) {
                throw new ParamException("Server addresses is empty!");
            }
            ArrayList hostAddress = Lists.newArrayList();
            for (ServerAddress serverAddress : this.hosts) {
                String host = serverAddress.getHost();
                ParamUtils.CheckNullEmptyString(host, "Host name");
                if (host.startsWith("https://")) {
                    host = host.replace("https://", "");
                    this.secure = true;
                } else if (host.startsWith("http://")) {
                    host = host.replace("http://", "");
                }
                hostAddress.add(ServerAddress.newBuilder().withHost(host).withPort(serverAddress.getPort()).withHealthPort(serverAddress.getHealthPort()).build());
                if (serverAddress.getPort() >= 0 && serverAddress.getPort() <= 65535) continue;
                throw new ParamException("Port is out of range!");
            }
            this.withHosts(hostAddress);
            return new MultiConnectParam(this);
        }
    }
}

