/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.connection;

import io.milvus.connection.ServerMonitor;
import io.milvus.connection.ServerSetting;
import io.milvus.exception.ParamException;
import io.milvus.param.QueryNodeSingleSearch;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ClusterFactory {
    private final List<ServerSetting> serverSettings;
    private ServerSetting master;
    private List<ServerSetting> availableServerSettings;
    private ServerMonitor monitor;

    private ClusterFactory(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder cannot be null");
        }
        this.serverSettings = builder.serverSettings;
        this.master = this.getDefaultServer();
        this.availableServerSettings = builder.serverSettings;
        if (builder.keepMonitor) {
            this.monitor = new ServerMonitor(this, builder.queryNodeSingleSearch);
            this.monitor.start();
        }
    }

    public ServerSetting getDefaultServer() {
        return this.serverSettings.get(0);
    }

    public boolean masterIsRunning() {
        List serverAddresses = this.availableServerSettings.stream().map(ServerSetting::getServerAddress).collect(Collectors.toList());
        return serverAddresses.contains(this.master.getServerAddress());
    }

    public void masterChange(ServerSetting serverSetting) {
        this.master = serverSetting;
    }

    public void availableServerChange(List<ServerSetting> serverSettings) {
        this.availableServerSettings = serverSettings;
    }

    public ServerSetting electMaster() {
        return CollectionUtils.isNotEmpty(this.availableServerSettings) ? this.availableServerSettings.get(0) : this.getDefaultServer();
    }

    public void close() {
        if (null != this.monitor) {
            this.monitor.close();
        }
    }

    public List<ServerSetting> getServerSettings() {
        return this.serverSettings;
    }

    public ServerSetting getMaster() {
        return this.master;
    }

    public List<ServerSetting> getAvailableServerSettings() {
        return this.availableServerSettings;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<ServerSetting> serverSettings;
        private boolean keepMonitor = false;
        private QueryNodeSingleSearch queryNodeSingleSearch;

        private Builder() {
        }

        public Builder withServerSetting(List<ServerSetting> serverSettings) {
            if (serverSettings == null) {
                throw new NullPointerException("serverSettings cannot be null");
            }
            this.serverSettings = serverSettings;
            return this;
        }

        public Builder keepMonitor(boolean enable) {
            this.keepMonitor = enable;
            return this;
        }

        public Builder withQueryNodeSingleSearch(QueryNodeSingleSearch queryNodeSingleSearch) {
            this.queryNodeSingleSearch = queryNodeSingleSearch;
            return this;
        }

        public ClusterFactory build() throws ParamException {
            if (CollectionUtils.isEmpty(this.serverSettings)) {
                throw new ParamException("Server settings is empty!");
            }
            return new ClusterFactory(this);
        }
    }
}

