/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.common.resourcegroup;

import io.milvus.grpc.KeyValuePair;
import io.milvus.param.ParamUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResourceGroupNodeFilter {
    private final Map<String, String> nodeLabels;

    private ResourceGroupNodeFilter(Builder builder) {
        this.nodeLabels = builder.nodeLabels;
    }

    public ResourceGroupNodeFilter(io.milvus.grpc.ResourceGroupNodeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter cannot be null");
        }
        this.nodeLabels = filter.getNodeLabelsList().stream().collect(Collectors.toMap(KeyValuePair::getKey, KeyValuePair::getValue));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static ResourceGroupNodeFilter fromGRPC(io.milvus.grpc.ResourceGroupNodeFilter filter) {
        return new ResourceGroupNodeFilter(filter);
    }

    public Map<String, String> getNodeLabels() {
        return this.nodeLabels;
    }

    public io.milvus.grpc.ResourceGroupNodeFilter toGRPC() {
        List<KeyValuePair> pair = ParamUtils.AssembleKvPair(this.nodeLabels);
        io.milvus.grpc.ResourceGroupNodeFilter result = io.milvus.grpc.ResourceGroupNodeFilter.newBuilder().addAllNodeLabels(pair).build();
        if (result == null) {
            throw new IllegalStateException("Failed to create GRPC ResourceGroupNodeFilter");
        }
        return result;
    }

    public String toString() {
        return "ResourceGroupNodeFilter{nodeLabels=" + this.nodeLabels + '}';
    }

    public static class Builder {
        private Map<String, String> nodeLabels = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withNodeLabel(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            this.nodeLabels.put(key, value);
            return this;
        }

        public ResourceGroupNodeFilter build() {
            return new ResourceGroupNodeFilter(this);
        }
    }
}

