/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package io.milvus.v2.service.rbac.request;

public class RevokePrivilegeReq {
    private String roleName;
    private String dbName;
    private String objectType;
    private String privilege;
    private String objectName;

    private RevokePrivilegeReq(RevokePrivilegeReqBuilder builder) {
        this.roleName = builder.roleName;
        this.dbName = builder.dbName;
        this.objectType = builder.objectType;
        this.privilege = builder.privilege;
        this.objectName = builder.objectName;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getDbName() {
        return dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getObjectType() {
        return objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getPrivilege() {
        return privilege;
    }

    public void setPrivilege(String privilege) {
        this.privilege = privilege;
    }

    public String getObjectName() {
        return objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    @Override
    public String toString() {
        return "RevokePrivilegeReq{" +
                "roleName='" + roleName + '\'' +
                ", dbName='" + dbName + '\'' +
                ", objectType='" + objectType + '\'' +
                ", privilege='" + privilege + '\'' +
                ", objectName='" + objectName + '\'' +
                '}';
    }

    public static RevokePrivilegeReqBuilder builder() {
        return new RevokePrivilegeReqBuilder();
    }

    public static class RevokePrivilegeReqBuilder {
        private String roleName;
        private String dbName;
        private String objectType;
        private String privilege;
        private String objectName;

        private RevokePrivilegeReqBuilder() {
        }

        public RevokePrivilegeReqBuilder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public RevokePrivilegeReqBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public RevokePrivilegeReqBuilder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public RevokePrivilegeReqBuilder privilege(String privilege) {
            this.privilege = privilege;
            return this;
        }

        public RevokePrivilegeReqBuilder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public RevokePrivilegeReq build() {
            return new RevokePrivilegeReq(this);
        }
    }
}
