/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package io.milvus.common.clientenum;

public enum FunctionType {
    UNKNOWN("Unknown", 0), // in milvus-proto, the name is "Unknown"
    BM25("BM25", 1), // Added missing name parameter
    TEXTEMBEDDING("TextEmbedding", 2), // in milvus-proto, the name is "TextEmbedding"
    RERANK("RERANK", 3); // Added missing name parameter

    private final String name;
    private final int code;

    FunctionType(String name, int code) {
        this.name = name;
        this.code = code;
    }

    // Getter method to replace @Getter annotation
    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static FunctionType fromName(String name) {
        for (FunctionType type : FunctionType.values()) {
            if (type.name().equals(name)) {
                return type;
            }
        }
        return null;
    }
}
