/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter.common.utils;

import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.param.collection.FieldType;
import io.milvus.v2.common.DataType;
import io.milvus.v2.service.collection.request.CreateCollectionReq;
import java.util.List;

public class V2AdapterUtils {
    public static CollectionSchemaParam convertV2Schema(CreateCollectionReq.CollectionSchema schemaV2) {
        CollectionSchemaParam.Builder schemaBuilder = CollectionSchemaParam.newBuilder().withEnableDynamicField(schemaV2.isEnableDynamicField());
        List<CreateCollectionReq.FieldSchema> fieldSchemaList = schemaV2.getFieldSchemaList();
        for (CreateCollectionReq.FieldSchema fieldSchema : fieldSchemaList) {
            FieldType.Builder fieldBuilder = FieldType.newBuilder().withName(fieldSchema.getName()).withDescription(fieldSchema.getDescription()).withDataType(io.milvus.grpc.DataType.valueOf(fieldSchema.getDataType().name())).withPrimaryKey(fieldSchema.getIsPrimaryKey()).withPartitionKey(fieldSchema.getIsPartitionKey()).withClusteringKey(fieldSchema.getIsClusteringKey()).withAutoID(fieldSchema.getAutoID());
            if (fieldSchema.getDimension() != null) {
                fieldBuilder.withDimension(fieldSchema.getDimension());
            }
            if (fieldSchema.getDataType() == DataType.VarChar && fieldSchema.getMaxLength() != null) {
                fieldBuilder.withMaxLength(fieldSchema.getMaxLength());
            }
            if (fieldSchema.getDataType() == DataType.Array) {
                fieldBuilder.withMaxCapacity(fieldSchema.getMaxCapacity());
                fieldBuilder.withElementType(io.milvus.grpc.DataType.valueOf(fieldSchema.getElementType().name()));
                if (fieldSchema.getElementType() == DataType.VarChar && fieldSchema.getMaxLength() != null) {
                    fieldBuilder.withMaxLength(fieldSchema.getMaxLength());
                }
            }
            schemaBuilder.addFieldType(fieldBuilder.build());
        }
        return schemaBuilder.build();
    }
}

