/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.bulkwriter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.milvus.bulkwriter.Buffer;
import io.milvus.bulkwriter.common.clientenum.BulkFileType;
import io.milvus.bulkwriter.common.clientenum.TypeSize;
import io.milvus.common.utils.ExceptionUtils;
import io.milvus.grpc.DataType;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.CollectionSchemaParam;
import io.milvus.param.collection.FieldType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BulkWriter {
    private static final Logger logger = LoggerFactory.getLogger(BulkWriter.class);
    protected CollectionSchemaParam collectionSchema;
    protected int chunkSize;
    protected BulkFileType fileType;
    protected int bufferSize;
    protected int bufferRowCount;
    protected int totalRowCount;
    protected Buffer buffer;
    protected ReentrantLock bufferLock;

    protected BulkWriter(CollectionSchemaParam collectionSchema, int chunkSize, BulkFileType fileType) {
        this.collectionSchema = collectionSchema;
        this.chunkSize = chunkSize;
        this.fileType = fileType;
        if (CollectionUtils.isEmpty(collectionSchema.getFieldTypes())) {
            ExceptionUtils.throwUnExpectedException("collection schema fields list is empty");
        }
        if (!this.hasPrimaryField(collectionSchema.getFieldTypes())) {
            ExceptionUtils.throwUnExpectedException("primary field is null");
        }
        this.bufferLock = new ReentrantLock();
        this.buffer = null;
        this.newBuffer();
    }

    protected Integer getBufferSize() {
        return this.bufferSize;
    }

    public Integer getBufferRowCount() {
        return this.bufferRowCount;
    }

    public Integer getTotalRowCount() {
        return this.totalRowCount;
    }

    protected Integer getChunkSize() {
        return this.chunkSize;
    }

    protected Buffer newBuffer() {
        Buffer oldBuffer = this.buffer;
        this.bufferLock.lock();
        this.buffer = new Buffer(this.collectionSchema, this.fileType);
        this.bufferLock.unlock();
        return oldBuffer;
    }

    public void appendRow(JsonObject row) throws IOException, InterruptedException {
        Map<String, Object> rowValues = this.verifyRow(row);
        this.bufferLock.lock();
        this.buffer.appendRow(rowValues);
        this.bufferLock.unlock();
    }

    protected void commit(boolean async) throws InterruptedException {
        this.bufferLock.lock();
        this.bufferSize = 0;
        this.bufferRowCount = 0;
        this.bufferLock.unlock();
    }

    protected String getDataPath() {
        return "";
    }

    private Map<String, Object> verifyRow(JsonObject row) {
        int rowSize = 0;
        HashMap<String, Object> rowValues = new HashMap<String, Object>();
        block7: for (FieldType fieldType : this.collectionSchema.getFieldTypes()) {
            JsonElement obj;
            String msg;
            String fieldName = fieldType.getName();
            if (fieldType.isPrimaryKey() && fieldType.isAutoID()) {
                if (!row.has(fieldName)) continue;
                msg = String.format("The primary key field '%s' is auto-id, no need to provide", fieldName);
                ExceptionUtils.throwUnExpectedException(msg);
            }
            if (!row.has(fieldName)) {
                msg = String.format("The field '%s' is missed in the row", fieldName);
                ExceptionUtils.throwUnExpectedException(msg);
            }
            if ((obj = row.get(fieldName)) == null || obj.isJsonNull()) {
                String msg2 = String.format("Illegal value for field '%s', value is null", fieldName);
                ExceptionUtils.throwUnExpectedException(msg2);
            }
            DataType dataType = fieldType.getDataType();
            switch (dataType) {
                case BinaryVector: 
                case FloatVector: 
                case Float16Vector: 
                case BFloat16Vector: 
                case SparseFloatVector: {
                    Pair<Object, Integer> objectAndSize = this.verifyVector(obj, fieldType);
                    rowValues.put(fieldName, objectAndSize.getLeft());
                    rowSize += ((Integer)objectAndSize.getRight()).intValue();
                    continue block7;
                }
                case VarChar: {
                    Pair<Object, Integer> objectAndSize = this.verifyVarchar(obj, fieldType);
                    rowValues.put(fieldName, objectAndSize.getLeft());
                    rowSize += ((Integer)objectAndSize.getRight()).intValue();
                    continue block7;
                }
                case JSON: {
                    Pair<Object, Integer> objectAndSize = this.verifyJSON(obj, fieldType);
                    rowValues.put(fieldName, objectAndSize.getLeft());
                    rowSize += ((Integer)objectAndSize.getRight()).intValue();
                    continue block7;
                }
                case Array: {
                    Pair<Object, Integer> objectAndSize = this.verifyArray(obj, fieldType);
                    rowValues.put(fieldName, objectAndSize.getLeft());
                    rowSize += ((Integer)objectAndSize.getRight()).intValue();
                    continue block7;
                }
                case Bool: 
                case Int8: 
                case Int16: 
                case Int32: 
                case Int64: 
                case Float: 
                case Double: {
                    Pair<Object, Integer> objectAndSize = this.verifyScalar(obj, fieldType);
                    rowValues.put(fieldName, objectAndSize.getLeft());
                    rowSize += ((Integer)objectAndSize.getRight()).intValue();
                    continue block7;
                }
            }
            String msg3 = String.format("Unsupported data type of field '%s', not implemented in BulkWriter.", fieldName);
            ExceptionUtils.throwUnExpectedException(msg3);
        }
        if (this.collectionSchema.isEnableDynamicField()) {
            JsonObject dynamicValues = new JsonObject();
            if (row.has("$meta")) {
                JsonElement value = row.get("$meta");
                if (!(value instanceof JsonObject)) {
                    String msg = String.format("Dynamic field '%s' value should be JSON dict format", "$meta");
                    ExceptionUtils.throwUnExpectedException(msg);
                }
                dynamicValues = (JsonObject)value;
            }
            for (String key : row.keySet()) {
                if (key.equals("$meta") || rowValues.containsKey(key)) continue;
                dynamicValues.add(key, row.get(key));
            }
            String strValues = dynamicValues.toString();
            rowValues.put("$meta", strValues);
            rowSize += strValues.length();
        }
        this.bufferLock.lock();
        this.bufferSize += rowSize;
        ++this.bufferRowCount;
        ++this.totalRowCount;
        this.bufferLock.unlock();
        return rowValues;
    }

    private Pair<Object, Integer> verifyVector(JsonElement object, FieldType fieldType) {
        Object vector = ParamUtils.checkFieldValue(fieldType, object);
        DataType dataType = fieldType.getDataType();
        switch (dataType) {
            case FloatVector: {
                return Pair.of((Object)vector, (Object)(((List)vector).size() * 4));
            }
            case BinaryVector: {
                return Pair.of((Object)vector, (Object)((ByteBuffer)vector).limit());
            }
            case Float16Vector: 
            case BFloat16Vector: {
                return Pair.of((Object)vector, (Object)(((ByteBuffer)vector).limit() * 2));
            }
            case SparseFloatVector: {
                return Pair.of((Object)vector, (Object)(((SortedMap)vector).size() * 12));
            }
        }
        ExceptionUtils.throwUnExpectedException("Unknown vector type");
        return null;
    }

    private Pair<Object, Integer> verifyVarchar(JsonElement object, FieldType fieldType) {
        Object varchar = ParamUtils.checkFieldValue(fieldType, object);
        return Pair.of((Object)varchar, (Object)String.valueOf(varchar).length());
    }

    private Pair<Object, Integer> verifyJSON(JsonElement object, FieldType fieldType) {
        String str = object.toString();
        return Pair.of((Object)str, (Object)str.length());
    }

    private Pair<Object, Integer> verifyArray(JsonElement object, FieldType fieldType) {
        Object array = ParamUtils.checkFieldValue(fieldType, object);
        int rowSize = 0;
        DataType elementType = fieldType.getElementType();
        if (TypeSize.contains(elementType)) {
            rowSize = TypeSize.getSize(elementType) * ((List)array).size();
        } else if (elementType == DataType.VarChar) {
            for (String str : (List)array) {
                rowSize += str.length();
            }
        } else {
            String msg = String.format("Unsupported element type for array field '%s'", fieldType.getName());
            ExceptionUtils.throwUnExpectedException(msg);
        }
        return Pair.of((Object)array, (Object)rowSize);
    }

    private Pair<Object, Integer> verifyScalar(JsonElement object, FieldType fieldType) {
        String msg;
        if (!object.isJsonPrimitive()) {
            String msg2 = String.format("Unsupported value type for field '%s'", fieldType.getName());
            ExceptionUtils.throwUnExpectedException(msg2);
        }
        JsonPrimitive value = object.getAsJsonPrimitive();
        DataType dataType = fieldType.getDataType();
        String fieldName = fieldType.getName();
        if (dataType == DataType.Bool) {
            if (!value.isBoolean()) {
                String msg3 = String.format("Unsupported value type for field '%s', value is not boolean", fieldName);
                ExceptionUtils.throwUnExpectedException(msg3);
            }
            return Pair.of((Object)value.getAsBoolean(), (Object)TypeSize.getSize(dataType));
        }
        if (!value.isNumber()) {
            msg = String.format("Unsupported value type for field '%s', value is not a number", fieldName);
            ExceptionUtils.throwUnExpectedException(msg);
        }
        switch (dataType) {
            case Int8: 
            case Int16: {
                return Pair.of((Object)value.getAsShort(), (Object)TypeSize.getSize(dataType));
            }
            case Int32: {
                return Pair.of((Object)value.getAsInt(), (Object)TypeSize.getSize(dataType));
            }
            case Int64: {
                return Pair.of((Object)value.getAsLong(), (Object)TypeSize.getSize(dataType));
            }
            case Float: {
                return Pair.of((Object)Float.valueOf(value.getAsFloat()), (Object)TypeSize.getSize(dataType));
            }
            case Double: {
                return Pair.of((Object)value.getAsDouble(), (Object)TypeSize.getSize(dataType));
            }
        }
        msg = String.format("Field '%s' is not a scalar field", fieldName);
        ExceptionUtils.throwUnExpectedException(msg);
        return Pair.of(null, null);
    }

    private boolean hasPrimaryField(List<FieldType> fieldTypes) {
        Optional<FieldType> primaryKeyField = fieldTypes.stream().filter(FieldType::isPrimaryKey).findFirst();
        return primaryKeyField.isPresent();
    }
}

