/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.v2.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.milvus.exception.ParamException;
import io.milvus.grpc.DataType;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.InsertRequest;
import io.milvus.grpc.MsgBase;
import io.milvus.grpc.MsgType;
import io.milvus.grpc.UpsertRequest;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.FieldType;
import io.milvus.response.DescCollResponseWrapper;
import io.milvus.v2.service.vector.request.InsertReq;
import io.milvus.v2.service.vector.request.UpsertReq;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;

public class DataUtils {
    private InsertRequest.Builder insertBuilder;
    private UpsertRequest.Builder upsertBuilder;

    public InsertRequest convertGrpcInsertRequest(@NonNull InsertReq requestParam, DescCollResponseWrapper wrapper) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        String collectionName = requestParam.getCollectionName();
        MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Insert).build();
        this.insertBuilder = InsertRequest.newBuilder().setCollectionName(collectionName).setBase(msgBase).setNumRows(requestParam.getData().size());
        this.upsertBuilder = null;
        this.fillFieldsData(requestParam, wrapper);
        return this.insertBuilder.build();
    }

    public UpsertRequest convertGrpcUpsertRequest(@NonNull UpsertReq requestParam, DescCollResponseWrapper wrapper) {
        if (requestParam == null) {
            throw new NullPointerException("requestParam is marked non-null but is null");
        }
        String collectionName = requestParam.getCollectionName();
        FieldType pk = wrapper.getPrimaryField();
        if (pk.isAutoID()) {
            throw new ParamException(String.format("Upsert don't support autoID==True, collection: %s", requestParam.getCollectionName()));
        }
        MsgBase msgBase = MsgBase.newBuilder().setMsgType(MsgType.Insert).build();
        this.upsertBuilder = UpsertRequest.newBuilder().setCollectionName(collectionName).setBase(msgBase).setNumRows(requestParam.getData().size());
        this.insertBuilder = null;
        this.fillFieldsData(requestParam, wrapper);
        return this.upsertBuilder.build();
    }

    private void addFieldsData(FieldData value) {
        if (this.insertBuilder != null) {
            this.insertBuilder.addFieldsData(value);
        } else if (this.upsertBuilder != null) {
            this.upsertBuilder.addFieldsData(value);
        }
    }

    private void setPartitionName(String value) {
        if (this.insertBuilder != null) {
            this.insertBuilder.setPartitionName(value);
        } else if (this.upsertBuilder != null) {
            this.upsertBuilder.setPartitionName(value);
        }
    }

    private void fillFieldsData(UpsertReq requestParam, DescCollResponseWrapper wrapper) {
        String partitionName = requestParam.getPartitionName();
        boolean isPartitionKeyEnabled = false;
        for (FieldType fieldType : wrapper.getFields()) {
            if (!fieldType.isPartitionKey()) continue;
            isPartitionKeyEnabled = true;
            break;
        }
        if (isPartitionKeyEnabled) {
            if (partitionName != null && !partitionName.isEmpty()) {
                String msg = "Collection " + requestParam.getCollectionName() + " has partition key, not allow to specify partition name";
                throw new ParamException(msg);
            }
        } else if (partitionName != null) {
            this.setPartitionName(partitionName);
        }
        List<JsonObject> rowFields = requestParam.getData();
        this.checkAndSetRowData(wrapper, rowFields);
    }

    private void fillFieldsData(InsertReq requestParam, DescCollResponseWrapper wrapper) {
        String partitionName = requestParam.getPartitionName();
        boolean isPartitionKeyEnabled = false;
        for (FieldType fieldType : wrapper.getFields()) {
            if (!fieldType.isPartitionKey()) continue;
            isPartitionKeyEnabled = true;
            break;
        }
        if (isPartitionKeyEnabled) {
            if (partitionName != null && !partitionName.isEmpty()) {
                String msg = "Collection " + requestParam.getCollectionName() + " has partition key, not allow to specify partition name";
                throw new ParamException(msg);
            }
        } else if (partitionName != null) {
            this.setPartitionName(partitionName);
        }
        List<JsonObject> rowFields = requestParam.getData();
        this.checkAndSetRowData(wrapper, rowFields);
    }

    private void checkAndSetRowData(DescCollResponseWrapper wrapper, List<JsonObject> rows) {
        List<FieldType> fieldTypes = wrapper.getFields();
        HashMap<String, ParamUtils.InsertDataInfo> nameInsertInfo = new HashMap<String, ParamUtils.InsertDataInfo>();
        ParamUtils.InsertDataInfo insertDynamicDataInfo = ParamUtils.InsertDataInfo.builder().fieldType(FieldType.newBuilder().withName("$meta").withDataType(DataType.JSON).withIsDynamic(true).build()).data(new LinkedList<Object>()).build();
        for (JsonObject row : rows) {
            for (FieldType fieldType : fieldTypes) {
                String msg;
                String fieldName = fieldType.getName();
                ParamUtils.InsertDataInfo insertDataInfo = nameInsertInfo.getOrDefault(fieldName, ParamUtils.InsertDataInfo.builder().fieldType(fieldType).data(new LinkedList<Object>()).build());
                JsonElement rowFieldData = row.get(fieldName);
                if (rowFieldData != null) {
                    if (fieldType.isAutoID()) {
                        msg = String.format("The primary key: %s is auto generated, no need to input.", fieldName);
                        throw new ParamException(msg);
                    }
                    Object fieldValue = ParamUtils.checkFieldValue(fieldType, rowFieldData);
                    insertDataInfo.getData().add(fieldValue);
                    nameInsertInfo.put(fieldName, insertDataInfo);
                    continue;
                }
                if (fieldType.isAutoID()) continue;
                msg = String.format("The field: %s is not provided.", fieldType.getName());
                throw new ParamException(msg);
            }
            if (!wrapper.getEnableDynamicField()) continue;
            JsonObject dynamicField = new JsonObject();
            for (String rowFieldName : row.keySet()) {
                if (nameInsertInfo.containsKey(rowFieldName)) continue;
                dynamicField.add(rowFieldName, row.get(rowFieldName));
            }
            insertDynamicDataInfo.getData().add(dynamicField);
        }
        for (String fieldNameKey : nameInsertInfo.keySet()) {
            ParamUtils.InsertDataInfo insertDataInfo = (ParamUtils.InsertDataInfo)nameInsertInfo.get(fieldNameKey);
            this.addFieldsData(ParamUtils.genFieldData(insertDataInfo.getFieldType(), insertDataInfo.getData()));
        }
        if (wrapper.getEnableDynamicField()) {
            this.addFieldsData(ParamUtils.genFieldData(insertDynamicDataInfo.getFieldType(), insertDynamicDataInfo.getData(), Boolean.TRUE));
        }
    }
}

